/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.gui.widget.zoom;

import bookeditor.client.gui.widget.zoom.ZoomSliderState;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class ZoomSliderRenderer {
    private static final int BORDER_NORMAL = -7631989;
    private static final int BORDER_HOVER = -1525684;
    private static final int BG_COLOR = -988964;
    private static final int TRACK_COLOR = -2832200;
    private static final int THUMB_COLOR = -988964;
    private static final int TEXT_COLOR = -16777216;

    public void render(class_332 ctx, int x, int y, int width, int height, ZoomSliderState state) {
        int borderColor = this.interpolateColor(-7631989, -1525684, state.hoverProgress);
        ctx.method_25294(x - 1, y - 1, x + width + 1, y + height + 1, borderColor);
        ctx.method_25294(x, y, x + width, y + height, -988964);
        int trackX = x + width / 2 - 2;
        int trackWidth = 4;
        int trackPadding = 20;
        int trackY = y + trackPadding;
        int trackHeight = height - trackPadding * 2 - 16;
        ctx.method_25294(trackX - 1, trackY - 1, trackX + trackWidth + 1, trackY + trackHeight + 1, -7631989);
        ctx.method_25294(trackX, trackY, trackX + trackWidth, trackY + trackHeight, -2832200);
        float normalized = 1.0f - state.getNormalizedPosition();
        int thumbY = trackY + (int)(normalized * (float)(trackHeight - 8));
        int thumbX = x + 2;
        int thumbWidth = width - 4;
        int thumbHeight = 8;
        ctx.method_25294(thumbX - 1, thumbY - 1, thumbX + thumbWidth + 1, thumbY + thumbHeight + 1, borderColor);
        ctx.method_25294(thumbX, thumbY, thumbX + thumbWidth, thumbY + thumbHeight, -988964);
        int topHighlight = this.addAlpha(-1, 0.3f);
        ctx.method_25294(thumbX + 1, thumbY + 1, thumbX + thumbWidth - 1, thumbY + 2, topHighlight);
        class_327 textRenderer = class_310.method_1551().field_1772;
        String percentText = String.format("%.0f%%", Float.valueOf(state.getDisplayZoomPercent()));
        int textWidth = textRenderer.method_1727(percentText);
        int textX = x + (width - textWidth) / 2;
        int textY = y + height - 14;
        ctx.method_51433(textRenderer, percentText, textX, textY, -16777216, false);
        String maxLabel = "500%";
        int maxLabelWidth = textRenderer.method_1727(maxLabel);
        ctx.method_51433(textRenderer, maxLabel, x + (width - maxLabelWidth) / 2, y + 4, -9740461, false);
    }

    private int interpolateColor(int color1, int color2, float t) {
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 + (float)(a2 - a1) * t);
        int r = (int)((float)r1 + (float)(r2 - r1) * t);
        int g = (int)((float)g1 + (float)(g2 - g1) * t);
        int b = (int)((float)b1 + (float)(b2 - b1) * t);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private int addAlpha(int color, float alpha) {
        int a = (int)(255.0f * alpha);
        return a << 24 | color & 0xFFFFFF;
    }
}

