/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.gui.widget.zoom;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ZoomSliderState {
    public static final float MIN_ZOOM = 1.0f;
    public static final float MAX_ZOOM = 5.0f;
    public static final float DEFAULT_ZOOM = 1.0f;
    private static final float SMOOTH_FACTOR = 0.2f;
    public float zoomLevel = 1.0f;
    private float displayZoom = 1.0f;
    public boolean dragging = false;
    public float hoverProgress = 0.0f;
    public long lastFrameTime = System.currentTimeMillis();

    public void setZoom(float zoom) {
        this.zoomLevel = Math.max(1.0f, Math.min(5.0f, zoom));
    }

    public void updateSmooth() {
        this.displayZoom += (this.zoomLevel - this.displayZoom) * 0.2f;
        if (Math.abs(this.displayZoom - this.zoomLevel) < 0.001f) {
            this.displayZoom = this.zoomLevel;
        }
    }

    public float getZoomPercent() {
        return this.zoomLevel * 100.0f;
    }

    public float getDisplayZoomPercent() {
        return this.displayZoom * 100.0f;
    }

    public float getNormalizedPosition() {
        return (this.displayZoom - 1.0f) / 4.0f;
    }

    public void setFromNormalizedPosition(float normalized) {
        normalized = Math.max(0.0f, Math.min(1.0f, normalized));
        this.displayZoom = this.zoomLevel = 1.0f + normalized * 4.0f;
    }

    public void updateHoverProgress(boolean isHovering, float deltaTime) {
        if (isHovering && this.hoverProgress < 1.0f) {
            this.hoverProgress = Math.min(1.0f, this.hoverProgress + deltaTime * 8.0f);
        } else if (!isHovering && this.hoverProgress > 0.0f) {
            this.hoverProgress = Math.max(0.0f, this.hoverProgress - deltaTime * 8.0f);
        }
    }

    public void reset() {
        this.zoomLevel = 1.0f;
        this.displayZoom = 1.0f;
    }
}

