/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.util;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public class PlankTextureUtil {
    private static final Map<String, class_2960> PLANK_TEXTURES = new HashMap<String, class_2960>();

    private static void registerPlank(String plankId, String namespace, String texturePath) {
        PLANK_TEXTURES.put(plankId, class_2960.method_43902((String)namespace, (String)texturePath));
    }

    public static class_2960 getTextureForPlank(String plankType) {
        if (plankType == null || plankType.isEmpty()) {
            return PlankTextureUtil.getDefaultTexture();
        }
        class_2960 texture = PLANK_TEXTURES.get(plankType);
        if (texture != null) {
            return texture;
        }
        try {
            class_2960 plankId = class_2960.method_12829((String)plankType);
            if (plankId != null) {
                return class_2960.method_43902((String)plankId.method_12836(), (String)("textures/block/" + plankId.method_12832() + ".png"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return PlankTextureUtil.getDefaultTexture();
    }

    public static class_2960 getDefaultTexture() {
        return class_2960.method_43902((String)"minecraft", (String)"textures/block/dark_oak_planks.png");
    }

    static {
        PlankTextureUtil.registerPlank("minecraft:oak_planks", "minecraft", "textures/block/oak_planks.png");
        PlankTextureUtil.registerPlank("minecraft:spruce_planks", "minecraft", "textures/block/spruce_planks.png");
        PlankTextureUtil.registerPlank("minecraft:birch_planks", "minecraft", "textures/block/birch_planks.png");
        PlankTextureUtil.registerPlank("minecraft:jungle_planks", "minecraft", "textures/block/jungle_planks.png");
        PlankTextureUtil.registerPlank("minecraft:acacia_planks", "minecraft", "textures/block/acacia_planks.png");
        PlankTextureUtil.registerPlank("minecraft:dark_oak_planks", "minecraft", "textures/block/dark_oak_planks.png");
        PlankTextureUtil.registerPlank("minecraft:mangrove_planks", "minecraft", "textures/block/mangrove_planks.png");
        PlankTextureUtil.registerPlank("minecraft:cherry_planks", "minecraft", "textures/block/cherry_planks.png");
        PlankTextureUtil.registerPlank("minecraft:bamboo_planks", "minecraft", "textures/block/bamboo_planks.png");
        PlankTextureUtil.registerPlank("minecraft:crimson_planks", "minecraft", "textures/block/crimson_planks.png");
        PlankTextureUtil.registerPlank("minecraft:warped_planks", "minecraft", "textures/block/warped_planks.png");
    }
}

