/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.net;

import bookeditor.Bookeditor;
import io.netty.buffer.Unpooled;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public final class BookNetworking {
    private static final Logger LOGGER = Logger.getLogger(BookNetworking.class.getName());
    public static final class_2960 UPDATE_BOOK = new class_2960("bookeditor", "update_book");
    public static final class_2960 UPDATE_BOOK_TOO_LARGE = new class_2960("bookeditor", "update_book_too_large");

    private BookNetworking() {
    }

    public static void registerServerReceivers() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)UPDATE_BOOK, (server, player, handler, buf, responseSender) -> {
            class_2487 nbt;
            class_1268 hand;
            try {
                hand = (class_1268)buf.method_10818(class_1268.class);
                try {
                    nbt = buf.method_10798();
                }
                catch (RuntimeException re) {
                    class_2540 resp = new class_2540(Unpooled.buffer());
                    resp.method_10814("book_nbt_too_large");
                    ServerPlayNetworking.send((class_3222)player, (class_2960)UPDATE_BOOK_TOO_LARGE, (class_2540)resp);
                    LOGGER.log(Level.WARNING, "BookNetworking: rejected incoming book NBT from player {0} - too large or invalid: {1}", new Object[]{player.method_5477().getString(), re.getMessage()});
                    return;
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "BookNetworking: failed to parse incoming update packet: " + ex.getMessage(), ex);
                return;
            }
            class_1268 finalHand = hand;
            class_2487 finalNbt = nbt;
            server.execute(() -> BookNetworking.applyOnServer(player, finalHand, finalNbt));
        });
    }

    private static void applyOnServer(class_3222 player, class_1268 hand, class_2487 nbt) {
        if (nbt == null) {
            return;
        }
        try {
            class_1799 stack = player.method_5998(hand);
            if (!stack.method_7960() && stack.method_7909() == Bookeditor.CREATIVE_BOOK) {
                class_2487 root = stack.method_7948();
                try {
                    root.method_10566("CreativeBook", (class_2520)nbt);
                    stack.method_7980(root);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.SEVERE, "BookNetworking: failed to apply NBT to item for player " + player.method_5477().getString() + ": " + ex.getMessage(), ex);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "BookNetworking: unexpected error while applying book NBT: " + ex.getMessage(), ex);
        }
    }
}

