/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.editor.brush;

import bookeditor.data.BookData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class BrushTool {
    private boolean brushMode = false;
    private int brushColor = -16777216;
    private int brushSize = 3;
    private BookData.Stroke currentStroke = null;

    public boolean isBrushMode() {
        return this.brushMode;
    }

    public void setBrushMode(boolean brushMode) {
        this.brushMode = brushMode;
    }

    public void setBrushColor(int argb) {
        this.brushColor = argb;
    }

    public void setBrushSize(int px) {
        this.brushSize = Math.max(1, Math.min(32, px));
    }

    public int getBrushSize() {
        return this.brushSize;
    }

    public boolean beginStrokeIfNeeded(boolean editable, BookData.Page page, int mx, int my, int contentLeft, int contentTop, double scale, int scrollY) {
        if (!editable || !this.brushMode || page == null) {
            return false;
        }
        this.currentStroke = new BookData.Stroke();
        this.currentStroke.color = this.brushColor;
        this.currentStroke.thickness = this.brushSize;
        this.addStrokePoint(mx, my, contentLeft, contentTop, scale, scrollY);
        return true;
    }

    public boolean continueStrokeIfActive(int mx, int my, int contentLeft, int contentTop, double scale, int scrollY) {
        if (this.currentStroke == null) {
            return false;
        }
        this.addStrokePoint(mx, my, contentLeft, contentTop, scale, scrollY);
        return true;
    }

    public boolean endStrokeIfActive(BookData.Page page) {
        if (this.currentStroke == null || page == null) {
            return false;
        }
        if (!this.currentStroke.points.isEmpty()) {
            page.strokes.add(this.currentStroke);
        }
        this.currentStroke = null;
        return true;
    }

    private void addStrokePoint(int mx, int my, int contentLeft, int contentTop, double scale, int scrollY) {
        if (this.currentStroke == null) {
            return;
        }
        int lx = (int)Math.floor((double)(mx - contentLeft) / scale);
        int ly = (int)Math.floor((double)(my - contentTop) / scale) + scrollY;
        if (lx < 0) {
            lx = 0;
        }
        if (ly < 0) {
            ly = 0;
        }
        lx = Math.min(lx, 960);
        ly = Math.min(ly, 600);
        this.currentStroke.points.add(new BookData.Stroke.Point(lx, ly));
    }

    public void renderStrokes(class_332 ctx, BookData.Page page, int startScreenX, int startScreenY, double s, int scrollY) {
        if (page == null) {
            return;
        }
        for (BookData.Stroke stroke : page.strokes) {
            int px = Math.max(1, (int)Math.round(s * (double)Math.max(1, stroke.thickness)));
            int half = px / 2;
            for (BookData.Stroke.Point p : stroke.points) {
                int sx = startScreenX + (int)Math.round(s * (double)p.x);
                int sy = startScreenY + (int)Math.round(s * (double)(p.y - scrollY));
                ctx.method_25294(sx - half, sy - half, sx + half + 1, sy + half + 1, stroke.color);
            }
        }
    }
}

