/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.editor.caret;

import bookeditor.data.BookData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class CaretSelectionModel {
    private int caretNode = 0;
    private int caretOffset = 0;
    private boolean selectionActive = false;
    private int selAnchorNode = -1;
    private int selAnchorOffset = 0;

    public void reset() {
        this.caretNode = 0;
        this.caretOffset = 0;
        this.clearSelection();
    }

    public int getCaretNode() {
        return this.caretNode;
    }

    public int getCaretOffset() {
        return this.caretOffset;
    }

    public void setCaret(int node, int offset) {
        this.caretNode = Math.max(0, node);
        this.caretOffset = Math.max(0, offset);
    }

    public void setAnchor(int node, int offset) {
        this.selAnchorNode = node;
        this.selAnchorOffset = offset;
        this.selectionActive = true;
    }

    public void clearSelection() {
        this.selectionActive = false;
        this.selAnchorNode = -1;
        this.selAnchorOffset = 0;
    }

    public boolean hasSelection() {
        return this.selectionActive && this.selAnchorNode >= 0 && (this.selAnchorNode != this.caretNode || this.selAnchorOffset != this.caretOffset);
    }

    public int[] selectionStart() {
        if (!this.hasSelection()) {
            return new int[]{this.caretNode, this.caretOffset};
        }
        if (this.posCmp(this.selAnchorNode, this.selAnchorOffset, this.caretNode, this.caretOffset) <= 0) {
            return new int[]{this.selAnchorNode, this.selAnchorOffset};
        }
        return new int[]{this.caretNode, this.caretOffset};
    }

    public int[] selectionEnd() {
        if (!this.hasSelection()) {
            return new int[]{this.caretNode, this.caretOffset};
        }
        if (this.posCmp(this.selAnchorNode, this.selAnchorOffset, this.caretNode, this.caretOffset) <= 0) {
            return new int[]{this.caretNode, this.caretOffset};
        }
        return new int[]{this.selAnchorNode, this.selAnchorOffset};
    }

    public void setSelectionActive(boolean activeWhenDiffers) {
        this.selectionActive = this.selAnchorNode < 0 ? false : activeWhenDiffers;
    }

    public void moveLeft(BookData.Page page) {
        BookData.Node n;
        if (page == null || page.nodes.isEmpty()) {
            return;
        }
        if (this.caretNode >= page.nodes.size()) {
            this.caretNode = page.nodes.size() - 1;
        }
        if ((n = page.nodes.get(this.caretNode)) instanceof BookData.TextNode) {
            BookData.TextNode tn = (BookData.TextNode)n;
            if (this.caretOffset > 0) {
                --this.caretOffset;
            } else if (this.caretNode > 0) {
                int n2;
                --this.caretNode;
                BookData.Node prev = page.nodes.get(this.caretNode);
                if (prev instanceof BookData.TextNode) {
                    BookData.TextNode pt = (BookData.TextNode)prev;
                    n2 = pt.text.length();
                } else {
                    n2 = 1;
                }
                this.caretOffset = n2;
            }
        } else if (this.caretOffset > 0) {
            this.caretOffset = 0;
        } else if (this.caretNode > 0) {
            int n3;
            --this.caretNode;
            BookData.Node prev = page.nodes.get(this.caretNode);
            if (prev instanceof BookData.TextNode) {
                BookData.TextNode pt = (BookData.TextNode)prev;
                n3 = pt.text.length();
            } else {
                n3 = 1;
            }
            this.caretOffset = n3;
        }
    }

    public void moveRight(BookData.Page page) {
        BookData.Node n;
        if (page == null || page.nodes.isEmpty()) {
            return;
        }
        if (this.caretNode >= page.nodes.size()) {
            this.caretNode = page.nodes.size() - 1;
        }
        if ((n = page.nodes.get(this.caretNode)) instanceof BookData.TextNode) {
            BookData.TextNode tn = (BookData.TextNode)n;
            if (this.caretOffset < tn.text.length()) {
                ++this.caretOffset;
            } else if (this.caretNode < page.nodes.size() - 1) {
                int n2;
                ++this.caretNode;
                BookData.Node node = page.nodes.get(this.caretNode);
                if (node instanceof BookData.TextNode) {
                    BookData.TextNode pt = (BookData.TextNode)node;
                    n2 = 0;
                } else {
                    n2 = 1;
                }
                this.caretOffset = n2;
            }
        } else if (this.caretOffset == 0) {
            this.caretOffset = 1;
        } else if (this.caretNode < page.nodes.size() - 1) {
            int n3;
            ++this.caretNode;
            BookData.Node node = page.nodes.get(this.caretNode);
            if (node instanceof BookData.TextNode) {
                BookData.TextNode pt = (BookData.TextNode)node;
                n3 = 0;
            } else {
                n3 = 1;
            }
            this.caretOffset = n3;
        }
    }

    public void selectAll(BookData.Page page) {
        int n;
        if (page == null || page.nodes.isEmpty()) {
            return;
        }
        this.selAnchorNode = 0;
        this.selAnchorOffset = 0;
        this.caretNode = page.nodes.size() - 1;
        BookData.Node last = page.nodes.get(this.caretNode);
        if (last instanceof BookData.TextNode) {
            BookData.TextNode t = (BookData.TextNode)last;
            n = t.text.length();
        } else {
            n = 1;
        }
        this.caretOffset = n;
        this.selectionActive = true;
    }

    public void ensureWithinPage(BookData.Page page) {
        BookData.Node node;
        if (page == null) {
            this.caretNode = 0;
            this.caretOffset = 0;
            return;
        }
        this.caretNode = Math.max(0, Math.min(this.caretNode, page.nodes.size() - 1));
        if (this.caretNode >= 0 && this.caretNode < page.nodes.size() && (node = page.nodes.get(this.caretNode)) instanceof BookData.TextNode) {
            BookData.TextNode t = (BookData.TextNode)node;
            this.caretOffset = Math.max(0, Math.min(this.caretOffset, t.text.length()));
        } else {
            this.caretOffset = Math.max(0, Math.min(this.caretOffset, 1));
        }
    }

    private int posCmp(int n1, int o1, int n2, int o2) {
        if (n1 != n2) {
            return Integer.compare(n1, n2);
        }
        return Integer.compare(o1, o2);
    }
}

