/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.editor.history;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;

@Environment(value=EnvType.CLIENT)
public class HistoryManager {
    private final Deque<class_2487> undoStack = new ArrayDeque<class_2487>();
    private final Deque<class_2487> redoStack = new ArrayDeque<class_2487>();
    private final int maxHistory;
    private boolean snapshotArmed = false;

    public HistoryManager() {
        this(50);
    }

    public HistoryManager(int maxHistory) {
        this.maxHistory = Math.max(1, maxHistory);
    }

    public void clear() {
        this.undoStack.clear();
        this.redoStack.clear();
        this.snapshotArmed = false;
    }

    public void pushSnapshot(Supplier<class_2487> supplier) {
        if (supplier == null) {
            return;
        }
        class_2487 snap = supplier.get();
        if (snap == null) {
            return;
        }
        if (this.undoStack.size() >= this.maxHistory) {
            this.undoStack.pollFirst();
        }
        this.undoStack.addLast(snap);
        this.redoStack.clear();
        this.snapshotArmed = true;
    }

    public void pushSnapshotNoClear(Supplier<class_2487> supplier) {
        if (supplier == null) {
            return;
        }
        class_2487 snap = supplier.get();
        if (snap == null) {
            return;
        }
        if (this.undoStack.size() >= this.maxHistory) {
            this.undoStack.pollFirst();
        }
        this.undoStack.addLast(snap);
        this.snapshotArmed = true;
    }

    public void pushSnapshotOnce(Supplier<class_2487> supplier) {
        if (!this.snapshotArmed) {
            this.pushSnapshot(supplier);
        }
    }

    public boolean undo(Consumer<class_2487> applier) {
        class_2487 prev;
        if (this.undoStack.size() <= 1) {
            return false;
        }
        class_2487 current = this.undoStack.pollLast();
        if (current != null) {
            this.redoStack.addLast(current);
        }
        if ((prev = this.undoStack.peekLast()) != null) {
            if (applier != null) {
                applier.accept(prev.method_10553());
            }
            this.trimRedo();
            this.snapshotArmed = false;
            return true;
        }
        return false;
    }

    public boolean redo(Consumer<class_2487> applier) {
        if (this.redoStack.isEmpty()) {
            return false;
        }
        class_2487 snap = this.redoStack.pollLast();
        if (snap != null) {
            if (applier != null) {
                applier.accept(snap.method_10553());
            }
            this.pushSnapshotNoClear(() -> snap.method_10553());
            this.snapshotArmed = false;
            return true;
        }
        return false;
    }

    private void trimRedo() {
        while (this.redoStack.size() > this.maxHistory) {
            this.redoStack.pollFirst();
        }
    }

    public void resetSnapshotArmed() {
        this.snapshotArmed = false;
    }
}

