/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.editor.page;

import bookeditor.client.editor.text.StyleParams;
import bookeditor.data.BookData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public final class PageNormalizer {
    private PageNormalizer() {
    }

    public static void normalize(BookData.Page page, StyleParams styleDefaults) {
        if (page == null) {
            return;
        }
        if (page.nodes.isEmpty()) {
            page.nodes.add(new BookData.TextNode("", styleDefaults.bold, styleDefaults.italic, styleDefaults.underline, styleDefaults.argb, styleDefaults.size, 0));
            return;
        }
        int i = 0;
        while (i < page.nodes.size()) {
            BookData.Node n = page.nodes.get(i);
            if (n instanceof BookData.TextNode) {
                BookData.TextNode prev;
                BookData.Node node;
                BookData.TextNode tn = (BookData.TextNode)n;
                if (tn.text.isEmpty() && page.nodes.size() > 1) {
                    page.nodes.remove(i);
                    continue;
                }
                if (i > 0 && (node = page.nodes.get(i - 1)) instanceof BookData.TextNode && (prev = (BookData.TextNode)node).sameStyle(tn)) {
                    prev.text = prev.text + tn.text;
                    page.nodes.remove(i);
                    continue;
                }
            }
            ++i;
        }
    }
}

