/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.editor.render;

import bookeditor.client.editor.caret.CaretSelectionModel;
import bookeditor.client.editor.text.TextHitTester;
import bookeditor.data.BookData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class TextLayoutRenderer {
    public CaretPos render(class_332 ctx, class_327 textRenderer, BookData.Page page, CaretSelectionModel caret, int startScreenX, int startScreenY, int scrollY, double scale, int textAreaW, int baseLineHeight) {
        CaretPos pos = new CaretPos();
        pos.x = 0;
        pos.y = 0;
        if (page == null) {
            return pos;
        }
        int selStartNode = -1;
        int selStartOff = 0;
        int selEndNode = -1;
        int selEndOff = 0;
        boolean hasSelection = caret.hasSelection();
        if (hasSelection) {
            int[] st = caret.selectionStart();
            int[] en = caret.selectionEnd();
            selStartNode = st[0];
            selStartOff = st[1];
            selEndNode = en[0];
            selEndOff = en[1];
        }
        int layoutY = 0;
        block0: for (int i = 0; i < page.nodes.size(); ++i) {
            BookData.Node n = page.nodes.get(i);
            if (!(n instanceof BookData.TextNode)) continue;
            BookData.TextNode tn = (BookData.TextNode)n;
            String text = tn.text == null ? "" : tn.text;
            float localScale = tn.size;
            class_2583 style = class_2583.field_24360.method_10982(Boolean.valueOf(tn.bold)).method_10978(Boolean.valueOf(tn.italic)).method_30938(Boolean.valueOf(tn.underline)).method_36139(tn.argb & 0xFFFFFF);
            int idx = 0;
            while (idx <= text.length()) {
                int lineStart = idx;
                int lineWidth = 0;
                boolean forcedBreak = false;
                while (idx < text.length()) {
                    char ch = text.charAt(idx);
                    if (ch == '\n') {
                        forcedBreak = true;
                        ++idx;
                        break;
                    }
                    int cw = (int)Math.ceil((float)textRenderer.method_1727(String.valueOf(ch)) * localScale);
                    if (lineWidth + cw > textAreaW) break;
                    lineWidth += cw;
                    ++idx;
                }
                int alignOffset = 0;
                if (tn.align == 1) {
                    alignOffset = Math.max(0, (textAreaW - lineWidth) / 2);
                } else if (tn.align == 2) {
                    alignOffset = Math.max(0, textAreaW - lineWidth);
                }
                if (hasSelection && i >= selStartNode && i <= selEndNode) {
                    int hStart = lineStart;
                    int hEnd = idx;
                    if (i == selStartNode) {
                        hStart = Math.max(hStart, selStartOff);
                    }
                    if (i == selEndNode) {
                        hEnd = Math.min(hEnd, selEndOff);
                    }
                    if (hStart < hEnd) {
                        int preW = TextHitTester.widthOf(textRenderer, text, lineStart, hStart, localScale);
                        int selW = TextHitTester.widthOf(textRenderer, text, hStart, hEnd, localScale);
                        int sx = startScreenX + (int)Math.round(scale * (double)(alignOffset + preW));
                        int sy = startScreenY + (int)Math.round(scale * (double)(layoutY - scrollY));
                        int sw = Math.max(1, (int)Math.round(scale * (double)selW));
                        int sh = Math.max(1, (int)Math.round(scale * (double)((float)(baseLineHeight + 2) * localScale)));
                        ctx.method_25294(sx, sy, sx + sw, sy + sh, 1429446911);
                    }
                }
                int drawX = alignOffset;
                int ci = lineStart;
                while (ci < idx) {
                    char ch = text.charAt(ci);
                    if (ch == '\n') {
                        ++ci;
                        continue;
                    }
                    if (i == caret.getCaretNode() && ci == caret.getCaretOffset()) {
                        pos.x = drawX;
                        pos.y = layoutY;
                    }
                    int cw = (int)Math.ceil((float)textRenderer.method_1727(String.valueOf(ch)) * localScale);
                    ctx.method_51448().method_22903();
                    ctx.method_51448().method_46416((float)(startScreenX + (int)Math.round(scale * (double)drawX)), (float)(startScreenY + (int)Math.round(scale * (double)(layoutY - scrollY))), 0.0f);
                    ctx.method_51448().method_22905((float)(scale * (double)localScale), (float)(scale * (double)localScale), 1.0f);
                    class_5250 t = class_2561.method_43470((String)String.valueOf(ch)).method_10862(style);
                    ctx.method_51439(textRenderer, (class_2561)t, 0, 0, tn.argb & 0xFFFFFF, false);
                    ctx.method_51448().method_22909();
                    drawX += cw;
                    ++ci;
                }
                if (i == caret.getCaretNode() && idx == caret.getCaretOffset()) {
                    pos.x = alignOffset + lineWidth;
                    pos.y = layoutY;
                }
                layoutY += (int)((float)(baseLineHeight + 2) * localScale);
                if (idx >= text.length()) continue block0;
                if (!forcedBreak) continue;
            }
        }
        return pos;
    }

    @Environment(value=EnvType.CLIENT)
    public static class CaretPos {
        public int x;
        public int y;
    }
}

