/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.editor.text;

import bookeditor.data.BookData;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_327;

@Environment(value=EnvType.CLIENT)
public final class TextHitTester {
    private TextHitTester() {
    }

    public static int widthOf(class_327 tr, String text, int from, int to, float localScale) {
        int w = 0;
        for (int i = Math.max(0, from); i < Math.min(text.length(), to); ++i) {
            char ch = text.charAt(i);
            w += (int)Math.ceil((float)tr.method_1727(String.valueOf(ch)) * localScale);
        }
        return w;
    }

    public static void placeCaretByApprox(class_327 tr, BookData.Page page, int[] caretNodeOut, int[] caretOffsetOut, int lx, int ly, int maxTextW) {
        int maxW = Math.max(0, maxTextW);
        Objects.requireNonNull(tr);
        int baseLine = 9;
        int targetNode = 0;
        int targetOffset = 0;
        int yCursor = 0;
        int lineX = 0;
        if (page == null) {
            caretNodeOut[0] = 0;
            caretOffsetOut[0] = 0;
            return;
        }
        for (int i = 0; i < page.nodes.size(); ++i) {
            int n;
            BookData.Node n2 = page.nodes.get(i);
            if (n2 instanceof BookData.TextNode) {
                BookData.TextNode tn = (BookData.TextNode)n2;
                String text = tn.text == null ? "" : tn.text;
                float scale = tn.size;
                int ci = 0;
                while (ci <= text.length() && ci != text.length()) {
                    char ch = text.charAt(ci);
                    if (ch == '\n') {
                        if (TextHitTester.approxHit(yCursor, ly, (int)((float)(baseLine + 2) * scale))) {
                            caretNodeOut[0] = i;
                            caretOffsetOut[0] = ci;
                            return;
                        }
                        yCursor += (int)((float)(baseLine + 2) * scale);
                        lineX = 0;
                        ++ci;
                        continue;
                    }
                    int charW = (int)((float)tr.method_1727(String.valueOf(ch)) * scale);
                    if (lineX + charW > maxW) {
                        if (TextHitTester.approxHit(yCursor, ly, (int)((float)(baseLine + 2) * scale))) {
                            caretNodeOut[0] = i;
                            caretOffsetOut[0] = ci;
                            return;
                        }
                        yCursor += (int)((float)(baseLine + 2) * scale);
                        lineX = 0;
                    }
                    if (TextHitTester.approxHit(yCursor, ly, (int)((float)(baseLine + 2) * scale))) {
                        if (lx < lineX + charW / 2) {
                            caretNodeOut[0] = i;
                            caretOffsetOut[0] = ci;
                            return;
                        }
                        caretNodeOut[0] = i;
                        caretOffsetOut[0] = ci + 1;
                    }
                    lineX += charW;
                    ++ci;
                }
                lineX = 0;
            }
            targetNode = i;
            BookData.Node node = page.nodes.get(i);
            if (node instanceof BookData.TextNode) {
                BookData.TextNode t = (BookData.TextNode)node;
                n = t.text.length();
            } else {
                n = 1;
            }
            targetOffset = n;
        }
        caretNodeOut[0] = targetNode;
        caretOffsetOut[0] = targetOffset;
    }

    private static boolean approxHit(int yTop, int ly, int h) {
        return ly >= yTop && ly <= yTop + h;
    }
}

