/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.gui.components;

import bookeditor.client.gui.base.WidgetHost;
import bookeditor.client.gui.widget.ColorPickerButton;
import bookeditor.client.gui.widget.RichTextEditorWidget;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_342;
import net.minecraft.class_4185;

@Environment(value=EnvType.CLIENT)
public class CanvasToolbar {
    private final WidgetHost host;
    private final RichTextEditorWidget editor;
    private final Runnable openInsertDialog;
    private final Runnable createNewPage;
    private final Runnable deleteCurrentPage;
    private final Runnable signAction;
    private final Runnable onDirty;
    private final Consumer<Integer> onCanvasColorChanged;
    private final int x;
    private final int y;
    private final int btnH;
    private final int gap;
    private class_4185 imgBtn;
    private ColorPickerButton canvasColorBtn;
    private class_4185 brushToggleBtn;
    private class_342 brushSizeField;
    private class_4185 brushApplyBtn;
    private class_4185 newPageBtn;
    private class_4185 deletePageBtn;
    private class_4185 signBtn;

    public CanvasToolbar(WidgetHost host, RichTextEditorWidget editor, Runnable openInsertDialog, Runnable createNewPage, Runnable deleteCurrentPage, Runnable signAction, Runnable onDirty, Consumer<Integer> onCanvasColorChanged, int x, int y, int btnH, int gap) {
        this.host = host;
        this.editor = editor;
        this.openInsertDialog = openInsertDialog;
        this.createNewPage = createNewPage;
        this.deleteCurrentPage = deleteCurrentPage;
        this.signAction = signAction;
        this.onDirty = onDirty;
        this.onCanvasColorChanged = onCanvasColorChanged;
        this.x = x;
        this.y = y;
        this.btnH = btnH;
        this.gap = gap;
    }

    public void build(int initialCanvasArgb) {
        int cx = this.x;
        this.imgBtn = this.addBtn(class_2561.method_43471((String)"screen.bookeditor.img").getString(), b -> this.openInsertDialog.run(), cx, 48);
        this.canvasColorBtn = new ColorPickerButton(cx += 48 + this.gap, this.y, argb -> {
            this.onCanvasColorChanged.accept(argb);
            this.editor.markSnapshot();
            this.onDirty.run();
        }, initialCanvasArgb);
        this.canvasColorBtn.method_25358(48);
        this.host.addDrawable(this.canvasColorBtn);
        this.brushToggleBtn = this.addBtn(class_2561.method_43471((String)"screen.bookeditor.brush").getString(), b -> {
            boolean newState = !this.editor.isBrushMode();
            this.editor.setBrushMode(newState);
            this.brushToggleBtn.method_25355((class_2561)class_2561.method_43471((String)(newState ? "screen.bookeditor.brush_on" : "screen.bookeditor.brush")));
        }, cx += 48 + this.gap, 56);
        this.brushSizeField = new class_342(this.host.getTextRenderer(), cx += 56 + this.gap, this.y, 36, this.btnH, (class_2561)class_2561.method_43471((String)"screen.bookeditor.brush_size"));
        this.brushSizeField.method_1852("3");
        this.host.addDrawable(this.brushSizeField);
        this.brushApplyBtn = this.addBtn(class_2561.method_43471((String)"screen.bookeditor.apply").getString(), b -> {
            try {
                int px = Math.max(1, Math.min(32, Integer.parseInt(this.brushSizeField.method_1882().trim())));
                this.editor.setBrushSize(px);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, cx += 36 + this.gap, 40);
        this.newPageBtn = this.addBtn(class_2561.method_43471((String)"screen.bookeditor.new_page").getString(), b -> this.createNewPage.run(), cx += 40 + this.gap, 56);
        this.deletePageBtn = this.addBtn(class_2561.method_43471((String)"screen.bookeditor.delete_page").getString(), b -> this.deleteCurrentPage.run(), cx += 56 + this.gap, 56);
        this.signBtn = this.addBtn(class_2561.method_43471((String)"screen.bookeditor.sign").getString(), b -> this.signAction.run(), cx += 56 + this.gap, 56);
    }

    public void setVisible(boolean v, boolean signed) {
        if (this.imgBtn != null) {
            this.imgBtn.field_22764 = v;
        }
        if (this.canvasColorBtn != null) {
            this.canvasColorBtn.field_22764 = v;
        }
        if (this.brushToggleBtn != null) {
            this.brushToggleBtn.field_22764 = v;
        }
        if (this.brushSizeField != null) {
            this.brushSizeField.field_22764 = v;
        }
        if (this.brushApplyBtn != null) {
            this.brushApplyBtn.field_22764 = v;
        }
        if (this.newPageBtn != null) {
            this.newPageBtn.field_22764 = v;
        }
        if (this.deletePageBtn != null) {
            this.deletePageBtn.field_22764 = v;
        }
        if (this.signBtn != null) {
            this.signBtn.field_22764 = v && !signed;
        }
    }

    public void setCanvasColor(int argb) {
        if (this.canvasColorBtn != null) {
            this.canvasColorBtn.setArgb(argb);
        }
    }

    public void setBrushSize(int px) {
        if (this.brushSizeField != null) {
            this.brushSizeField.method_1852(Integer.toString(px));
        }
        this.editor.setBrushSize(px);
    }

    private class_4185 addBtn(String label, class_4185.class_4241 onPress, int cx, int w) {
        class_4185 btn = class_4185.method_46430((class_2561)class_2561.method_43470((String)label), (class_4185.class_4241)onPress).method_46434(cx, this.y, w, this.btnH).method_46431();
        this.host.addDrawable(btn);
        return btn;
    }
}

