/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.gui.components;

import bookeditor.client.gui.base.WidgetHost;
import bookeditor.client.gui.widget.ColorPickerButton;
import bookeditor.client.gui.widget.RichTextEditorWidget;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_342;
import net.minecraft.class_4185;

@Environment(value=EnvType.CLIENT)
public class FormattingToolbar {
    private final WidgetHost host;
    private final RichTextEditorWidget editor;
    private final Runnable onDirty;
    private final int x;
    private final int y;
    private final int btnH;
    private final int gap;
    private class_4185 undoBtn;
    private class_4185 redoBtn;
    private class_4185 boldBtn;
    private class_4185 italicBtn;
    private class_4185 underlineBtn;
    private class_342 sizeField;
    private class_4185 applySizeBtn;
    private class_4185 alignLeftBtn;
    private class_4185 alignCenterBtn;
    private class_4185 alignRightBtn;
    private ColorPickerButton textColorBtn;

    public FormattingToolbar(WidgetHost host, RichTextEditorWidget editor, Runnable onDirty, int x, int y, int btnH, int gap) {
        this.host = host;
        this.editor = editor;
        this.onDirty = onDirty;
        this.x = x;
        this.y = y;
        this.btnH = btnH;
        this.gap = gap;
    }

    public void build() {
        int cx = this.x;
        this.undoBtn = this.addBtn("\u21b6", b -> {
            if (this.editor.undo()) {
                this.onDirty.run();
            }
        }, cx);
        this.redoBtn = this.addBtn("\u21b7", b -> {
            if (this.editor.redo()) {
                this.onDirty.run();
            }
        }, cx += 18 + this.gap);
        this.boldBtn = this.addBtn("B", b -> {
            this.editor.setBold(!this.editor.isBold());
            this.refreshFormatButtons();
            this.onDirty.run();
        }, cx += 18 + this.gap);
        this.italicBtn = this.addBtn("I", b -> {
            this.editor.setItalic(!this.editor.isItalic());
            this.refreshFormatButtons();
            this.onDirty.run();
        }, cx += 18 + this.gap);
        this.underlineBtn = this.addBtn("U", b -> {
            this.editor.setUnderline(!this.editor.isUnderline());
            this.refreshFormatButtons();
            this.onDirty.run();
        }, cx += 18 + this.gap);
        this.sizeField = new class_342(this.host.getTextRenderer(), cx += 18 + this.gap, this.y, 40, this.btnH, (class_2561)class_2561.method_43471((String)"screen.bookeditor.size"));
        this.sizeField.method_1852("1.0");
        this.host.addDrawable(this.sizeField);
        this.applySizeBtn = this.addBtn(class_2561.method_43471((String)"screen.bookeditor.apply_size").getString(), b -> {
            try {
                float s = Math.max(0.5f, Math.min(3.0f, Float.parseFloat(this.sizeField.method_1882().trim())));
                this.editor.setSize(s);
                this.onDirty.run();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, cx += 40 + this.gap, 46);
        this.alignLeftBtn = this.addBtn("L", b -> {
            this.editor.setAlignment(0);
            this.onDirty.run();
        }, cx += 46 + this.gap);
        this.alignCenterBtn = this.addBtn("C", b -> {
            this.editor.setAlignment(1);
            this.onDirty.run();
        }, cx += 18 + this.gap);
        this.alignRightBtn = this.addBtn("R", b -> {
            this.editor.setAlignment(2);
            this.onDirty.run();
        }, cx += 18 + this.gap);
        this.textColorBtn = new ColorPickerButton(cx += 18 + this.gap, this.y, argb -> {
            this.editor.setColor(argb);
            this.editor.setBrushColor(argb);
            this.onDirty.run();
        }, -14671840);
        this.textColorBtn.method_25358(18);
        this.host.addDrawable(this.textColorBtn);
        this.refreshFormatButtons();
    }

    private class_4185 addBtn(String label, class_4185.class_4241 onPress, int cx) {
        return this.addBtn(label, onPress, cx, 18);
    }

    private class_4185 addBtn(String label, class_4185.class_4241 onPress, int cx, int w) {
        class_4185 btn = class_4185.method_46430((class_2561)class_2561.method_43470((String)label), (class_4185.class_4241)onPress).method_46434(cx, this.y, w, this.btnH).method_46431();
        this.host.addDrawable(btn);
        return btn;
    }

    public void setVisible(boolean v) {
        if (this.undoBtn != null) {
            this.undoBtn.field_22764 = v;
        }
        if (this.redoBtn != null) {
            this.redoBtn.field_22764 = v;
        }
        if (this.boldBtn != null) {
            this.boldBtn.field_22764 = v;
        }
        if (this.italicBtn != null) {
            this.italicBtn.field_22764 = v;
        }
        if (this.underlineBtn != null) {
            this.underlineBtn.field_22764 = v;
        }
        if (this.sizeField != null) {
            this.sizeField.field_22764 = v;
        }
        if (this.applySizeBtn != null) {
            this.applySizeBtn.field_22764 = v;
        }
        if (this.alignLeftBtn != null) {
            this.alignLeftBtn.field_22764 = v;
        }
        if (this.alignCenterBtn != null) {
            this.alignCenterBtn.field_22764 = v;
        }
        if (this.alignRightBtn != null) {
            this.alignRightBtn.field_22764 = v;
        }
        if (this.textColorBtn != null) {
            this.textColorBtn.field_22764 = v;
        }
    }

    public void refreshFormatButtons() {
        if (this.boldBtn != null) {
            this.boldBtn.method_25355((class_2561)class_2561.method_43470((String)(this.editor.isBold() ? "[B]" : "B")));
        }
        if (this.italicBtn != null) {
            this.italicBtn.method_25355((class_2561)class_2561.method_43470((String)(this.editor.isItalic() ? "[I]" : "I")));
        }
        if (this.underlineBtn != null) {
            this.underlineBtn.method_25355((class_2561)class_2561.method_43470((String)(this.editor.isUnderline() ? "[U]" : "U")));
        }
    }

    public void setInitialTextColor(int argb) {
        if (this.textColorBtn != null) {
            this.textColorBtn.setArgb(argb);
        }
        this.editor.setColor(argb);
        this.editor.setBrushColor(argb);
    }

    public void setFontSizeField(float s) {
        if (this.sizeField != null) {
            this.sizeField.method_1852(Float.toString(s));
        }
    }
}

