/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.gui.screen;

import bookeditor.client.gui.base.WidgetHost;
import bookeditor.client.gui.components.CanvasToolbar;
import bookeditor.client.gui.components.FormattingToolbar;
import bookeditor.client.gui.components.NavigationBar;
import bookeditor.client.gui.render.AuthorBadgeRenderer;
import bookeditor.client.gui.screen.ImageInsertScreen;
import bookeditor.client.gui.widget.RichTextEditorWidget;
import bookeditor.client.net.BookSyncService;
import bookeditor.client.util.ImageCache;
import bookeditor.data.BookData;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class WysiwygBookScreen
extends class_437
implements WidgetHost {
    private static final int MARGIN = 10;
    private static final int GAP = 5;
    private static final int BTN_H = 18;
    private final class_1268 hand;
    private final class_1799 stack;
    private BookData data;
    private class_342 titleField;
    private int toolsPage = 0;
    private final int toolsPages = 2;
    private class_4185 toolsPrevBtn;
    private class_4185 toolsNextBtn;
    private RichTextEditorWidget editor;
    private int page = 0;
    private int toolbarY = 0;
    private NavigationBar navigationBar;
    private FormattingToolbar formattingToolbar;
    private CanvasToolbar canvasToolbar;

    public WysiwygBookScreen(class_1799 stack, class_1268 hand) {
        super((class_2561)class_2561.method_43471((String)"screen.bookeditor.title"));
        this.stack = stack;
        this.hand = hand;
        this.data = BookData.readFrom(stack);
        if (this.data.pages.isEmpty()) {
            BookData.Page p = new BookData.Page();
            p.nodes.add(new BookData.TextNode("", false, false, false, -14671840, 1.0f, 0));
            this.data.pages.add(p);
        }
    }

    protected void method_25426() {
        int rowY;
        this.method_37067();
        int y = 10;
        if (!this.data.signed) {
            int titleW = Math.max(220, this.field_22789 - 20 - 160);
            this.titleField = new class_342(this.field_22793, 10, y, titleW, 18, (class_2561)class_2561.method_43471((String)"screen.bookeditor.book_title"));
            this.titleField.method_1852(this.data.title);
            this.method_37063((class_364)this.titleField);
        } else {
            this.titleField = null;
        }
        int navBlockW = 115;
        int navX = this.field_22789 - 10 - navBlockW;
        int navY = y;
        this.navigationBar = new NavigationBar(this, navX, navY, 18, () -> this.page, () -> this.data.pages.size(), p -> this.setPage((int)p, true), () -> this.changePage(-1), () -> this.changePage(1));
        this.navigationBar.build();
        int x = 10;
        this.toolsPrevBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u25c0"), b -> {
            this.toolsPage = (this.toolsPage - 1 + 2) % 2;
            this.updateToolsVisibility();
        }).method_46434(x, y += 22, 18, 18).method_46431());
        this.toolsNextBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u25b6"), b -> {
            this.toolsPage = (this.toolsPage + 1) % 2;
            this.updateToolsVisibility();
        }).method_46434(x += 23, y, 18, 18).method_46431());
        this.toolbarY = rowY = y;
        int editorY = rowY + 18 + 6;
        int editorX = 10;
        int editorW = this.field_22789 - 20;
        int editorH = Math.max(160, this.field_22790 - editorY - 10);
        this.editor = new RichTextEditorWidget(this.field_22793, editorX, editorY, editorW, editorH, !this.data.signed, ImageCache::requestTexture, this::onDirty);
        int toolsStartX = 56;
        this.formattingToolbar = new FormattingToolbar(this, this.editor, this::onDirty, toolsStartX, rowY, 18, 5);
        this.formattingToolbar.build();
        this.canvasToolbar = new CanvasToolbar(this, this.editor, this::openInsert, this::createNewPage, this::deleteCurrentPage, this::sign, this::onDirty, argb -> {
            this.data.pages.get((int)this.page).bgArgb = argb;
        }, toolsStartX, rowY, 18, 5);
        this.canvasToolbar.build(this.data.pages.get((int)this.page).bgArgb);
        this.editor.setContent(this.data.pages.get(this.page));
        this.formattingToolbar.setInitialTextColor(-14671840);
        this.canvasToolbar.setCanvasColor(this.data.pages.get((int)this.page).bgArgb);
        this.canvasToolbar.setBrushSize(3);
        this.method_37063((class_364)this.editor);
        this.prefetchPageImages();
        this.applySignedVisibility();
        this.updateToolsVisibility();
    }

    private void changePage(int dir) {
        this.setPage(this.page + dir, true);
    }

    private void setPage(int idx, boolean clamp) {
        if (clamp) {
            if (idx < 0) {
                idx = 0;
            }
            if (idx >= this.data.pages.size()) {
                idx = this.data.pages.size() - 1;
            }
        } else {
            if (idx < 0) {
                idx = 0;
            }
            if (idx > this.data.pages.size()) {
                idx = this.data.pages.size();
            }
        }
        this.page = idx;
        this.editor.setContent(this.data.pages.get(this.page));
        this.canvasToolbar.setCanvasColor(this.data.pages.get((int)this.page).bgArgb);
        this.navigationBar.updateFieldFromState();
        this.prefetchPageImages();
    }

    private void prefetchPageImages() {
        BookData.Page p = this.data.pages.get(this.page);
        for (BookData.Node n : p.nodes) {
            if (!(n instanceof BookData.ImageNode)) continue;
            BookData.ImageNode img = (BookData.ImageNode)n;
            if (img.url == null || img.url.isEmpty()) continue;
            ImageCache.requestTexture(img.url);
        }
    }

    private void openInsert() {
        if (this.data.signed) {
            return;
        }
        class_310.method_1551().method_1507((class_437)new ImageInsertScreen(this, (url, w, h, isGifIgnored) -> {
            this.editor.markSnapshot();
            this.editor.insertImage(url, w, h, false);
            this.onDirty();
        }, false));
    }

    private void createNewPage() {
        if (!this.data.signed) {
            this.onDirty();
            BookData.Page p = new BookData.Page();
            BookData.Page cur = this.data.pages.get(this.page);
            p.bgArgb = cur.bgArgb;
            p.nodes.add(new BookData.TextNode("", false, false, false, -14671840, 1.0f, 0));
            this.data.pages.add(this.page + 1, p);
            this.setPage(this.page + 1, false);
            this.onDirty();
        }
    }

    private void deleteCurrentPage() {
        if (!this.data.signed) {
            if (this.data.pages.size() > 1) {
                this.data.pages.remove(this.page);
                int newIndex = Math.max(0, Math.min(this.page, this.data.pages.size() - 1));
                this.setPage(newIndex, false);
            } else {
                BookData.Page p = this.data.pages.get(0);
                p.nodes.clear();
                p.strokes.clear();
                p.nodes.add(new BookData.TextNode("", false, false, false, -14671840, 1.0f, 0));
                this.editor.setContent(p);
            }
            this.onDirty();
        }
    }

    private void onDirty() {
        if (this.titleField != null) {
            this.data.title = this.titleField.method_1882();
        }
        BookSyncService.sendUpdate(this.hand, this.data);
    }

    private void applySignedVisibility() {
        boolean toolsVisible;
        boolean bl = toolsVisible = !this.data.signed;
        if (this.titleField != null) {
            this.titleField.field_22764 = toolsVisible;
        }
        if (this.navigationBar != null) {
            this.navigationBar.setVisible(true);
        }
        this.updateToolsVisibility();
        if (this.editor != null) {
            this.editor.setEditable(!this.data.signed);
        }
    }

    private void updateToolsVisibility() {
        boolean p1;
        boolean toolsVisible = !this.data.signed;
        boolean p0 = this.toolsPage == 0 && toolsVisible;
        boolean bl = p1 = this.toolsPage == 1 && toolsVisible;
        if (this.formattingToolbar != null) {
            this.formattingToolbar.setVisible(p0);
        }
        if (this.canvasToolbar != null) {
            this.canvasToolbar.setVisible(p1, this.data.signed);
        }
        if (this.toolsPrevBtn != null) {
            this.toolsPrevBtn.field_22764 = toolsVisible;
        }
        if (this.toolsNextBtn != null) {
            this.toolsNextBtn.field_22764 = toolsVisible;
        }
    }

    private void sign() {
        if (this.data.signed) {
            return;
        }
        if (this.titleField != null) {
            this.data.title = this.titleField.method_1882();
        }
        class_746 p = Objects.requireNonNull(class_310.method_1551().field_1724);
        this.data.authorName = p.method_7334().getName();
        this.data.authorUuid = p.method_5667();
        this.data.signed = true;
        this.applySignedVisibility();
        this.onDirty();
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        this.method_25420(ctx);
        super.method_25394(ctx, mouseX, mouseY, delta);
        if (this.data.signed) {
            AuthorBadgeRenderer.renderBadge(ctx, this.field_22793, this.field_22789, this.toolbarY, 18, this.data);
        }
    }

    public void method_25410(class_310 mc, int width, int height) {
        super.method_25410(mc, width, height);
        this.method_25426();
    }

    public void method_25419() {
        this.onDirty();
        super.method_25419();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.data.signed && WysiwygBookScreen.method_25441()) {
            if (keyCode == 66) {
                this.editor.setBold(!this.editor.isBold());
                if (this.formattingToolbar != null) {
                    this.formattingToolbar.refreshFormatButtons();
                }
                this.onDirty();
                return true;
            }
            if (keyCode == 73) {
                this.editor.setItalic(!this.editor.isItalic());
                if (this.formattingToolbar != null) {
                    this.formattingToolbar.refreshFormatButtons();
                }
                this.onDirty();
                return true;
            }
            if (keyCode == 85) {
                this.editor.setUnderline(!this.editor.isUnderline());
                if (this.formattingToolbar != null) {
                    this.formattingToolbar.refreshFormatButtons();
                }
                this.onDirty();
                return true;
            }
            if (keyCode == 90) {
                if (this.editor.undo()) {
                    this.onDirty();
                }
                return true;
            }
            if (keyCode == 89) {
                if (this.editor.redo()) {
                    this.onDirty();
                }
                return true;
            }
        }
        if (!this.data.signed && (keyCode == 257 || keyCode == 335) && WysiwygBookScreen.method_25441()) {
            this.sign();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public <T extends class_364 & class_4068> T addDrawable(T widget) {
        return (T)this.method_37063(widget);
    }

    @Override
    public class_327 getTextRenderer() {
        return this.field_22793;
    }
}

