/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.gui.widget;

import bookeditor.client.editor.brush.BrushTool;
import bookeditor.client.editor.caret.CaretSelectionModel;
import bookeditor.client.editor.history.HistoryManager;
import bookeditor.client.editor.image.ImageInteraction;
import bookeditor.client.editor.page.PageNormalizer;
import bookeditor.client.editor.render.CaretPainter;
import bookeditor.client.editor.render.ImageRenderer;
import bookeditor.client.editor.render.TextLayoutRenderer;
import bookeditor.client.editor.text.StyleParams;
import bookeditor.client.editor.text.TextEditOps;
import bookeditor.client.editor.text.TextHitTester;
import bookeditor.data.BookData;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_6382;

@Environment(value=EnvType.CLIENT)
public class RichTextEditorWidget
extends class_339 {
    private static final int PAD_OUT = 8;
    private static final int PAD_IN = 8;
    private static final int LOGICAL_W = 960;
    private static final int LOGICAL_H = 600;
    private final class_327 textRenderer;
    private final Consumer<String> onImageUrlSeen;
    private final Runnable onDirty;
    private boolean editable;
    private BookData.Page page;
    private boolean bold;
    private boolean italic;
    private boolean underline;
    private int argb = -14671840;
    private float size = 1.0f;
    private final CaretSelectionModel caret = new CaretSelectionModel();
    private final BrushTool brushTool = new BrushTool();
    private final ImageInteraction imageInteraction = new ImageInteraction();
    private final HistoryManager history = new HistoryManager();
    private final TextLayoutRenderer textLayoutRenderer = new TextLayoutRenderer();
    private final ImageRenderer imageRenderer = new ImageRenderer();
    private final CaretPainter caretPainter = new CaretPainter();
    private final TextEditOps textOps = new TextEditOps();
    private int scrollY = 0;

    public RichTextEditorWidget(class_327 textRenderer, int x, int y, int width, int height, boolean editable, Consumer<String> onImageUrlSeen, Runnable onDirty) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)"RichEditor"));
        this.textRenderer = textRenderer;
        this.editable = editable;
        this.onImageUrlSeen = onImageUrlSeen;
        this.onDirty = onDirty;
        this.field_22763 = editable;
    }

    public void setHeight(int height) {
        this.field_22759 = Math.max(40, height);
        this.clampScroll();
    }

    public void setBounds(int x, int y, int width, int height) {
        this.method_46421(x);
        this.method_46419(y);
        this.method_25358(width);
        this.field_22759 = Math.max(40, height);
        this.clampScroll();
    }

    private int innerLeft() {
        return this.method_46426() + 8;
    }

    private int innerTop() {
        return this.method_46427() + 8;
    }

    private int innerW() {
        return Math.max(0, this.method_25368() - 16);
    }

    private int innerH() {
        return Math.max(0, this.method_25364() - 16);
    }

    private double scale() {
        double sw = (double)this.innerW() / 976.0;
        double sh = (double)this.innerH() / 616.0;
        return Math.max(0.1, Math.min(sw, sh));
    }

    private int canvasScreenLeft() {
        int scaledW = (int)Math.floor(this.scale() * 976.0);
        return this.innerLeft() + Math.max(0, (this.innerW() - scaledW) / 2);
    }

    private int canvasScreenTop() {
        int scaledH = (int)Math.floor(this.scale() * 616.0);
        return this.innerTop() + Math.max(0, (this.innerH() - scaledH) / 2);
    }

    private int contentScreenLeft() {
        return this.canvasScreenLeft() + (int)Math.round(this.scale() * 8.0);
    }

    private int contentScreenTop() {
        return this.canvasScreenTop() + (int)Math.round(this.scale() * 8.0);
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.field_22763 = editable;
    }

    public void setContent(BookData.Page page) {
        this.page = page;
        this.normalize();
        this.caret.reset();
        if (page != null) {
            this.caret.setCaret(Math.min(page.nodes.size() - 1, 0), 0);
        }
        this.scrollY = 0;
        if (this.onImageUrlSeen != null && page != null) {
            for (BookData.Node n : page.nodes) {
                if (!(n instanceof BookData.ImageNode)) continue;
                BookData.ImageNode img = (BookData.ImageNode)n;
                if (img.url == null || img.url.isEmpty()) continue;
                this.onImageUrlSeen.accept(img.url);
            }
        }
        this.history.clear();
        this.pushSnapshot();
        this.caretPainter.reset();
    }

    public void markSnapshot() {
        this.pushSnapshot();
    }

    public boolean undo() {
        boolean applied = this.history.undo(this::applySnapshot);
        if (applied) {
            this.caretPainter.reset();
        }
        return applied;
    }

    public boolean redo() {
        boolean applied = this.history.redo(this::applySnapshot);
        if (applied) {
            this.caretPainter.reset();
        }
        return applied;
    }

    private void pushSnapshot() {
        if (this.page == null) {
            return;
        }
        this.history.pushSnapshot(this.page::toNbt);
    }

    private void pushSnapshotOnce() {
        if (this.page != null) {
            this.history.pushSnapshotOnce(this.page::toNbt);
        }
    }

    private void applySnapshot(class_2487 snap) {
        BookData.Page restored = BookData.Page.fromNbt(snap.method_10553());
        this.page.nodes.clear();
        this.page.strokes.clear();
        this.page.bgArgb = restored.bgArgb;
        this.page.nodes.addAll(restored.nodes);
        this.page.strokes.addAll(restored.strokes);
        this.imageInteraction.clearSelection();
        this.caret.clearSelection();
        if (this.onImageUrlSeen != null) {
            for (BookData.Node n : this.page.nodes) {
                if (!(n instanceof BookData.ImageNode)) continue;
                BookData.ImageNode img = (BookData.ImageNode)n;
                if (img.url == null || img.url.isEmpty()) continue;
                this.onImageUrlSeen.accept(img.url);
            }
        }
        this.clampScroll();
    }

    private void notifyDirty() {
        this.history.resetSnapshotArmed();
        if (this.onDirty != null) {
            this.onDirty.run();
        }
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public boolean isBold() {
        return this.bold;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public void setUnderline(boolean underline) {
        this.underline = underline;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public void setColor(int argb) {
        this.argb = argb;
        this.brushTool.setBrushColor(argb);
    }

    public void setSize(float size) {
        this.size = size;
    }

    private StyleParams style() {
        return new StyleParams(this.bold, this.italic, this.underline, this.argb, this.size);
    }

    public boolean isBrushMode() {
        return this.brushTool.isBrushMode();
    }

    public void setBrushMode(boolean brushMode) {
        this.brushTool.setBrushMode(brushMode);
    }

    public void setBrushColor(int argb) {
        this.brushTool.setBrushColor(argb);
    }

    public void setBrushSize(int px) {
        this.brushTool.setBrushSize(px);
    }

    public void setAlignment(int align) {
        if (this.page == null || this.page.nodes.isEmpty()) {
            return;
        }
        int idx = Math.max(0, Math.min(this.caret.getCaretNode(), this.page.nodes.size() - 1));
        BookData.Node n = this.page.nodes.get(idx);
        if (n instanceof BookData.TextNode) {
            BookData.TextNode tn = (BookData.TextNode)n;
            this.pushSnapshotOnce();
            tn.align = align;
            this.notifyDirty();
        }
    }

    public void insertImage(String url, int w, int h, boolean gif) {
        if (!this.editable || this.page == null) {
            return;
        }
        this.pushSnapshotOnce();
        int maxImgW = Math.max(8, 960);
        BookData.ImageNode img = new BookData.ImageNode(url, Math.max(8, Math.min(w, maxImgW)), Math.max(8, h), gif);
        img.absolute = true;
        img.x = 0;
        img.y = Math.max(0, Math.min(this.scrollY + 10, Math.max(0, 600 - img.h)));
        if (this.onImageUrlSeen != null && url != null && !url.isEmpty()) {
            this.onImageUrlSeen.accept(url);
        }
        this.page.nodes.add(img);
        this.caret.setCaret(this.page.nodes.size() - 1, 1);
        this.normalize();
        this.notifyDirty();
    }

    private void normalize() {
        PageNormalizer.normalize(this.page, this.style());
        this.caret.ensureWithinPage(this.page);
    }

    protected void method_48579(class_332 ctx, int mouseX, int mouseY, float delta) {
        int frame = this.method_49606() ? -5592406 : -4276546;
        ctx.method_25294(this.method_46426() - 1, this.method_46427() - 1, this.method_46426() + this.method_25368() + 1, this.method_46427() + this.method_25364() + 1, frame);
        ctx.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), -1052689);
        int cLeft = this.canvasScreenLeft();
        int cTop = this.canvasScreenTop();
        int scaledW = (int)Math.floor(this.scale() * 976.0);
        int scaledH = (int)Math.floor(this.scale() * 616.0);
        int bg = this.page != null ? this.page.bgArgb : -460552;
        ctx.method_25294(cLeft, cTop, cLeft + scaledW, cTop + scaledH, bg);
        ctx.method_25294(cLeft - 1, cTop - 1, cLeft + scaledW + 1, cTop, 0x33000000);
        ctx.method_25294(cLeft - 1, cTop + scaledH, cLeft + scaledW + 1, cTop + scaledH + 1, 0x33000000);
        ctx.method_25294(cLeft - 1, cTop, cLeft, cTop + scaledH, 0x33000000);
        ctx.method_25294(cLeft + scaledW, cTop, cLeft + scaledW + 1, cTop + scaledH, 0x33000000);
        int scLeft = Math.max(this.innerLeft(), cLeft);
        int scTop = Math.max(this.innerTop(), cTop);
        int scRight = Math.min(this.innerLeft() + this.innerW(), cLeft + scaledW);
        int scBottom = Math.min(this.innerTop() + this.innerH(), cTop + scaledH);
        if (scRight > scLeft && scBottom > scTop) {
            ctx.method_44379(scLeft, scTop, scRight, scBottom);
        }
        int startScreenX = this.contentScreenLeft();
        int startScreenY = this.contentScreenTop();
        double s = this.scale();
        this.brushTool.renderStrokes(ctx, this.page, startScreenX, startScreenY, s, this.scrollY);
        this.imageInteraction.beginFrame();
        Objects.requireNonNull(this.textRenderer);
        TextLayoutRenderer.CaretPos caretPos = this.textLayoutRenderer.render(ctx, this.textRenderer, this.page, this.caret, startScreenX, startScreenY, this.scrollY, s, 960, 9);
        this.imageRenderer.render(ctx, this.page, this.imageInteraction, startScreenX, startScreenY - (int)Math.round(s * (double)this.scrollY), this.canvasScreenTop(), s, 960, 600);
        this.imageInteraction.renderSelectionHandles(ctx);
        boolean bl = this.method_25370();
        boolean bl2 = this.brushTool.isBrushMode();
        boolean bl3 = this.caret.hasSelection();
        int n = caretPos.x;
        int n2 = caretPos.y;
        int n3 = startScreenY - (int)Math.round(s * (double)this.scrollY);
        Objects.requireNonNull(this.textRenderer);
        this.caretPainter.renderCaret(ctx, bl, this.editable, bl2, bl3, n, n2, startScreenX, n3, s, 9);
        ctx.method_44380();
    }

    private void clampScroll() {
        this.scrollY = 0;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        this.clampScroll();
        return true;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        this.method_25365(true);
        int mx = (int)mouseX;
        int my = (int)mouseY;
        if (this.brushTool.beginStrokeIfNeeded(this.editable, this.page, mx, my, this.contentScreenLeft(), this.contentScreenTop(), this.scale(), this.scrollY)) {
            this.pushSnapshotOnce();
            return true;
        }
        this.imageInteraction.clearSelection();
        if (this.imageInteraction.mouseClicked(mx, my, this.editable, this::pushSnapshotOnce, this.page)) {
            return true;
        }
        int localX = (int)Math.floor((double)(mx - this.contentScreenLeft()) / this.scale());
        int localY = (int)Math.floor((double)(my - this.contentScreenTop()) / this.scale()) + this.scrollY;
        int[] cNode = new int[1];
        int[] cOff = new int[1];
        TextHitTester.placeCaretByApprox(this.textRenderer, this.page, cNode, cOff, localX, localY, 960);
        this.caret.setCaret(cNode[0], cOff[0]);
        this.caret.clearSelection();
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dx, double dy) {
        if (!this.editable) {
            return false;
        }
        int mx = (int)mouseX;
        int my = (int)mouseY;
        if (this.brushTool.continueStrokeIfActive(mx, my, this.contentScreenLeft(), this.contentScreenTop(), this.scale(), this.scrollY)) {
            return true;
        }
        if (this.imageInteraction.mouseDragged(mx, my, true, this.scale(), this.page)) {
            return true;
        }
        int localX = (int)Math.floor((double)(mx - this.contentScreenLeft()) / this.scale());
        int localY = (int)Math.floor((double)(my - this.contentScreenTop()) / this.scale()) + this.scrollY;
        int[] cNode = new int[1];
        int[] cOff = new int[1];
        TextHitTester.placeCaretByApprox(this.textRenderer, this.page, cNode, cOff, localX, localY, 960);
        if (!this.caret.hasSelection()) {
            this.caret.setAnchor(this.caret.getCaretNode(), this.caret.getCaretOffset());
        }
        this.caret.setCaret(cNode[0], cOff[0]);
        int[] st = this.caret.selectionStart();
        this.caret.setSelectionActive(cNode[0] != st[0] || cOff[0] != st[1]);
        return true;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        boolean changed = false;
        if (this.imageInteraction.mouseReleased()) {
            changed = true;
        }
        if (this.brushTool.endStrokeIfActive(this.page)) {
            changed = true;
        }
        if (changed) {
            this.notifyDirty();
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (!this.editable || this.page == null || !this.method_25370() || this.brushTool.isBrushMode()) {
            return false;
        }
        if (chr == '\r') {
            chr = (char)10;
        }
        if (chr < ' ' && chr != '\n' && chr != '\t') {
            return false;
        }
        this.pushSnapshotOnce();
        if (this.caret.hasSelection()) {
            this.textOps.deleteSelection(this.page, this.caret, this.style());
        }
        this.textOps.insertChar(this.page, this.caret, this.style(), chr);
        this.notifyDirty();
        return true;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.method_25370()) {
            return false;
        }
        if ((keyCode == 261 || keyCode == 259) && this.page != null && this.imageInteraction.getSelectedImageIndex() >= 0) {
            this.pushSnapshotOnce();
            this.imageInteraction.deleteSelectedIfImage(this.page);
            this.notifyDirty();
            return true;
        }
        if (!this.editable || this.page == null || this.brushTool.isBrushMode()) {
            return false;
        }
        boolean ctrl = class_437.method_25441();
        if (ctrl && keyCode == 65) {
            this.caret.selectAll(this.page);
            return true;
        }
        if (keyCode == 259) {
            this.pushSnapshotOnce();
            if (this.caret.hasSelection()) {
                this.textOps.deleteSelection(this.page, this.caret, this.style());
            } else {
                this.textOps.backspace(this.page, this.caret, this.style());
            }
            this.caret.clearSelection();
            this.notifyDirty();
            return true;
        }
        if (keyCode == 261) {
            this.pushSnapshotOnce();
            if (this.caret.hasSelection()) {
                this.textOps.deleteSelection(this.page, this.caret, this.style());
            } else {
                this.textOps.deleteForward(this.page, this.caret, this.style());
            }
            this.caret.clearSelection();
            this.notifyDirty();
            return true;
        }
        if (keyCode == 257 || keyCode == 335) {
            boolean r;
            this.pushSnapshotOnce();
            if (this.caret.hasSelection()) {
                this.textOps.deleteSelection(this.page, this.caret, this.style());
            }
            if (r = this.method_25400('\n', modifiers)) {
                this.caret.clearSelection();
                this.notifyDirty();
            }
            return r;
        }
        if (keyCode == 263) {
            if ((modifiers & 1) != 0) {
                if (!this.caret.hasSelection()) {
                    this.caret.setAnchor(this.caret.getCaretNode(), this.caret.getCaretOffset());
                }
                this.caret.moveLeft(this.page);
                this.caret.setSelectionActive(true);
            } else {
                this.caret.moveLeft(this.page);
                this.caret.clearSelection();
            }
            return true;
        }
        if (keyCode == 262) {
            if ((modifiers & 1) != 0) {
                if (!this.caret.hasSelection()) {
                    this.caret.setAnchor(this.caret.getCaretNode(), this.caret.getCaretOffset());
                }
                this.caret.moveRight(this.page);
                this.caret.setSelectionActive(true);
            } else {
                this.caret.moveRight(this.page);
                this.caret.clearSelection();
            }
            return true;
        }
        if (keyCode == 266) {
            this.method_25401(0.0, 0.0, 1.0);
            return true;
        }
        if (keyCode == 267) {
            this.method_25401(0.0, 0.0, -1.0);
            return true;
        }
        return false;
    }

    protected void method_47399(class_6382 builder) {
    }
}

