/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.util;

import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public final class ImageCache {
    private static final Map<String, class_2960> CACHE = new ConcurrentHashMap<String, class_2960>();
    private static final Map<class_2960, Boolean> LOADED = new ConcurrentHashMap<class_2960, Boolean>();

    public static class_2960 getTexture(String url) {
        if (url == null || url.isEmpty()) {
            return null;
        }
        class_2960 id = CACHE.get(url);
        if (id == null || !Boolean.TRUE.equals(LOADED.get(id))) {
            return null;
        }
        return id;
    }

    public static void requestTexture(String url) {
        if (url == null || url.isEmpty()) {
            return;
        }
        CACHE.computeIfAbsent(url, ImageCache::download);
    }

    private static class_2960 download(String url) {
        String path = "bookeditor/img/" + Integer.toHexString(url.hashCode());
        class_2960 id = new class_2960(path);
        new Thread(() -> {
            try (InputStream in = new URL(url).openStream();){
                class_1011 img = class_1011.method_4309((InputStream)in);
                class_1043 tex = new class_1043(img);
                class_310.method_1551().execute(() -> {
                    class_310.method_1551().method_1531().method_4616(id, (class_1044)tex);
                    LOADED.put(id, true);
                });
            }
            catch (Exception ex) {
                LOADED.put(id, false);
            }
        }, "BookEditor-ImageLoader").start();
        return id;
    }

    private ImageCache() {
    }
}

