/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.data;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;

public class BookData {
    public static final String ROOT = "CreativeBook";
    public static final String PAGES = "pages";
    public static final String TITLE = "title";
    public static final String AUTHOR_NAME = "authorName";
    public static final String AUTHOR_UUID = "authorUuid";
    public static final String SIGNED = "signed";
    public String title = "";
    public String authorName = "";
    public UUID authorUuid = class_156.field_25140;
    public boolean signed = false;
    public final List<Page> pages = new ArrayList<Page>();
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;

    private static int clampAlign(int a) {
        if (a < 0) {
            return 0;
        }
        if (a > 2) {
            return 2;
        }
        return a;
    }

    public static void ensureDefaults(class_1799 stack, class_1657 player) {
        class_2487 root = stack.method_7948();
        if (!root.method_10573(ROOT, 10)) {
            BookData data = new BookData();
            data.title = class_2561.method_43471((String)"bookeditor.default_title").getString();
            data.authorName = player.method_7334().getName();
            data.authorUuid = player.method_5667();
            data.signed = false;
            Page p = new Page();
            p.bgArgb = -460552;
            p.nodes.add(new TextNode(class_2561.method_43471((String)"bookeditor.default_page").getString(), false, false, false, -14671840, 1.0f, 0));
            data.pages.add(p);
            BookData.writeTo(stack, data);
        }
    }

    public static BookData readFrom(class_1799 stack) {
        BookData d = new BookData();
        class_2487 root = stack.method_7948();
        if (!root.method_10573(ROOT, 10)) {
            return d;
        }
        class_2487 cb = root.method_10562(ROOT);
        d.title = cb.method_10558(TITLE);
        d.authorName = cb.method_10558(AUTHOR_NAME);
        if (cb.method_10573(AUTHOR_UUID, 8)) {
            try {
                d.authorUuid = UUID.fromString(cb.method_10558(AUTHOR_UUID));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        d.signed = cb.method_10577(SIGNED);
        class_2499 pages = cb.method_10554(PAGES, 10);
        for (int i = 0; i < pages.size(); ++i) {
            d.pages.add(Page.fromNbt(pages.method_10602(i)));
        }
        return d;
    }

    public static void writeTo(class_1799 stack, BookData data) {
        class_2487 root = stack.method_7948();
        root.method_10566(ROOT, (class_2520)BookData.toNbt(data));
        stack.method_7980(root);
    }

    public static class_2487 toNbt(BookData d) {
        class_2487 cb = new class_2487();
        cb.method_10582(TITLE, d.title);
        cb.method_10582(AUTHOR_NAME, d.authorName == null ? "" : d.authorName);
        if (d.authorUuid != null) {
            cb.method_10582(AUTHOR_UUID, d.authorUuid.toString());
        }
        cb.method_10556(SIGNED, d.signed);
        class_2499 pages = new class_2499();
        for (Page p : d.pages) {
            pages.add((Object)p.toNbt());
        }
        cb.method_10566(PAGES, (class_2520)pages);
        return cb;
    }

    public static class Page {
        public final List<Node> nodes = new ArrayList<Node>();
        public final List<Stroke> strokes = new ArrayList<Stroke>();
        public int bgArgb = -460552;

        public class_2487 toNbt() {
            class_2487 c = new class_2487();
            class_2499 list = new class_2499();
            for (Node n : this.nodes) {
                list.add((Object)n.toNbt());
            }
            c.method_10566("nodes", (class_2520)list);
            class_2499 strokesNbt = new class_2499();
            for (Stroke s : this.strokes) {
                strokesNbt.add((Object)s.toNbt());
            }
            c.method_10566("strokes", (class_2520)strokesNbt);
            c.method_10569("bg", this.bgArgb);
            return c;
        }

        public static Page fromNbt(class_2487 c) {
            Page p = new Page();
            class_2499 list = c.method_10554("nodes", 10);
            for (int i = 0; i < list.size(); ++i) {
                p.nodes.add(Node.fromNbt(list.method_10602(i)));
            }
            if (c.method_10573("strokes", 9)) {
                class_2499 sList = c.method_10554("strokes", 10);
                for (int i = 0; i < sList.size(); ++i) {
                    p.strokes.add(Stroke.fromNbt(sList.method_10602(i)));
                }
            }
            if (c.method_10573("bg", 3)) {
                p.bgArgb = c.method_10550("bg");
            }
            return p;
        }
    }

    public static class TextNode
    extends Node {
        public String text;
        public boolean bold;
        public boolean italic;
        public boolean underline;
        public int argb;
        public float size;
        public int align;

        public TextNode(String text, boolean bold, boolean italic, boolean underline, int argb, float size, int align) {
            this.text = text;
            this.bold = bold;
            this.italic = italic;
            this.underline = underline;
            this.argb = argb;
            this.size = size;
            this.align = align;
        }

        @Override
        public String type() {
            return "text";
        }

        @Override
        public class_2487 toNbt() {
            class_2487 c = new class_2487();
            c.method_10582("type", "text");
            c.method_10582("text", this.text);
            c.method_10556("bold", this.bold);
            c.method_10556("italic", this.italic);
            c.method_10556("underline", this.underline);
            c.method_10569("argb", this.argb);
            c.method_10548("size", this.size);
            c.method_10569("align", this.align);
            return c;
        }

        public static TextNode fromNbt(class_2487 c) {
            return new TextNode(c.method_10558("text"), c.method_10577("bold"), c.method_10577("italic"), c.method_10577("underline"), c.method_10573("argb", 3) ? c.method_10550("argb") : -14671840, c.method_10573("size", 5) ? c.method_10583("size") : 1.0f, c.method_10573("align", 3) ? BookData.clampAlign(c.method_10550("align")) : 0);
        }

        public TextNode copy() {
            return new TextNode(this.text, this.bold, this.italic, this.underline, this.argb, this.size, this.align);
        }

        public boolean sameStyle(TextNode other) {
            return this.bold == other.bold && this.italic == other.italic && this.underline == other.underline && this.argb == other.argb && Float.compare(this.size, other.size) == 0 && this.align == other.align;
        }
    }

    public static class Stroke {
        public int color = -16777216;
        public int thickness = 2;
        public final List<Point> points = new ArrayList<Point>();

        public class_2487 toNbt() {
            class_2487 c = new class_2487();
            c.method_10569("color", this.color);
            c.method_10569("thickness", this.thickness);
            class_2499 pts = new class_2499();
            for (Point p : this.points) {
                class_2487 pc = new class_2487();
                pc.method_10569("x", p.x);
                pc.method_10569("y", p.y);
                pts.add((Object)pc);
            }
            c.method_10566("points", (class_2520)pts);
            return c;
        }

        public static Stroke fromNbt(class_2487 c) {
            Stroke s = new Stroke();
            if (c.method_10573("color", 3)) {
                s.color = c.method_10550("color");
            }
            if (c.method_10573("thickness", 3)) {
                s.thickness = c.method_10550("thickness");
            }
            class_2499 pts = c.method_10554("points", 10);
            for (int i = 0; i < pts.size(); ++i) {
                class_2487 pc = pts.method_10602(i);
                s.points.add(new Point(pc.method_10550("x"), pc.method_10550("y")));
            }
            return s;
        }

        public static class Point {
            public int x;
            public int y;

            public Point(int x, int y) {
                this.x = x;
                this.y = y;
            }
        }
    }

    public static class ImageNode
    extends Node {
        public String url;
        public int w;
        public int h;
        public boolean gif;
        public int align = 0;
        public boolean absolute = true;
        public int x = 0;
        public int y = 0;

        public ImageNode(String url, int w, int h, boolean gif) {
            this.url = url;
            this.w = w;
            this.h = h;
            this.gif = gif;
        }

        @Override
        public String type() {
            return "image";
        }

        @Override
        public class_2487 toNbt() {
            class_2487 c = new class_2487();
            c.method_10582("type", "image");
            c.method_10582("url", this.url == null ? "" : this.url);
            c.method_10569("w", this.w);
            c.method_10569("h", this.h);
            c.method_10556("gif", this.gif);
            c.method_10569("align", this.align);
            c.method_10556("abs", this.absolute);
            c.method_10569("x", this.x);
            c.method_10569("y", this.y);
            return c;
        }

        public static ImageNode fromNbt(class_2487 c) {
            ImageNode img = new ImageNode(c.method_10558("url"), c.method_10550("w"), c.method_10550("h"), c.method_10577("gif"));
            img.align = c.method_10573("align", 3) ? BookData.clampAlign(c.method_10550("align")) : 0;
            img.absolute = c.method_10573("abs", 1) ? c.method_10577("abs") : true;
            img.x = c.method_10573("x", 3) ? c.method_10550("x") : 0;
            img.y = c.method_10573("y", 3) ? c.method_10550("y") : 0;
            return img;
        }
    }

    public static abstract class Node {
        public abstract String type();

        public abstract class_2487 toNbt();

        public static Node fromNbt(class_2487 c) {
            String t = c.method_10558("type");
            if ("text".equals(t)) {
                return TextNode.fromNbt(c);
            }
            if ("image".equals(t)) {
                return ImageNode.fromNbt(c);
            }
            return new TextNode("", false, false, false, -14671840, 1.0f, 0);
        }
    }
}

