/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.gui.render;

import bookeditor.data.BookData;
import bookeditor.util.SkullStackUtil;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public final class AuthorBadgeRenderer {
    private AuthorBadgeRenderer() {
    }

    public static void renderBadge(class_332 ctx, class_327 textRenderer, int screenWidth, int toolbarY, int toolbarBtnHeight, BookData data) {
        if (data == null || !data.signed) {
            return;
        }
        int centerX = screenWidth / 2;
        int headSize = 20;
        int gap = 6;
        int padX = 8;
        int padY = 3;
        int y = toolbarY + (toolbarBtnHeight - headSize) / 2;
        int nameW = data.authorName == null ? 0 : textRenderer.method_1727(data.authorName);
        int badgeW = padX * 2 + nameW;
        int groupW = data.authorName == null || data.authorName.isEmpty() ? headSize : headSize + gap + badgeW;
        int headX = centerX - groupW / 2;
        if (data.title != null && !data.title.isEmpty()) {
            int titleW = textRenderer.method_1727(data.title);
            int titleX = centerX - titleW / 2;
            Objects.requireNonNull(textRenderer);
            int titleY = Math.max(0, toolbarY - 9 - 4);
            ctx.method_51439(textRenderer, (class_2561)class_2561.method_43470((String)data.title), titleX, titleY, -16777216, false);
        }
        if (data.authorName != null && !data.authorName.isEmpty()) {
            int badgeX = headX + headSize + gap;
            Objects.requireNonNull(textRenderer);
            int badgeY = y + (headSize - (padY * 2 + 9)) / 2;
            Objects.requireNonNull(textRenderer);
            int badgeH = padY * 2 + 9;
            int badgeBg = -988964;
            int badgeBorder = -7631989;
            int shadowColor = 0x331E1E1E;
            int topHighlight = 0x4DFFFFFF;
            int bottomShadow = 0x26000000;
            ctx.method_25294(badgeX + 1, badgeY + badgeH, badgeX + badgeW - 1, badgeY + badgeH + 1, shadowColor);
            ctx.method_25294(badgeX, badgeY, badgeX + badgeW, badgeY + badgeH, badgeBg);
            ctx.method_25294(badgeX + 1, badgeY + 1, badgeX + badgeW - 1, badgeY + 2, topHighlight);
            ctx.method_25294(badgeX + 1, badgeY + badgeH - 2, badgeX + badgeW - 1, badgeY + badgeH - 1, bottomShadow);
            ctx.method_25294(badgeX, badgeY, badgeX + badgeW, badgeY + 1, badgeBorder);
            ctx.method_25294(badgeX, badgeY + badgeH - 1, badgeX + badgeW, badgeY + badgeH, badgeBorder);
            ctx.method_25294(badgeX, badgeY, badgeX + 1, badgeY + badgeH, badgeBorder);
            ctx.method_25294(badgeX + badgeW - 1, badgeY, badgeX + badgeW, badgeY + badgeH, badgeBorder);
            ctx.method_51439(textRenderer, (class_2561)class_2561.method_43470((String)data.authorName), badgeX + padX, badgeY + padY, -16777216, false);
        }
        if (data.authorUuid != null || data.authorName != null && !data.authorName.isEmpty()) {
            class_1799 skull = SkullStackUtil.playerHeadStack(data.authorName, data.authorUuid);
            float scale = (float)headSize / 16.0f;
            ctx.method_51448().method_22903();
            ctx.method_51448().method_46416((float)headX, (float)y, 0.0f);
            ctx.method_51448().method_22905(scale, scale, 1.0f);
            ctx.method_51427(skull, 0, 0);
            ctx.method_51448().method_22909();
        }
    }
}

