/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.gui.widget.button.colorpicker;

import java.awt.Color;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ColorConverter {
    public static int hsbToArgb(float h, float s, float b) {
        int rgb = Color.HSBtoRGB(h, s, b);
        return 0xFF000000 | rgb & 0xFFFFFF;
    }

    public static float[] rgbToHsb(int r, int g, int b) {
        float[] hsb = new float[3];
        Color.RGBtoHSB(r, g, b, hsb);
        return hsb;
    }

    public static int interpolateColor(int c1, int c2, float progress) {
        int a1 = c1 >> 24 & 0xFF;
        int r1 = c1 >> 16 & 0xFF;
        int g1 = c1 >> 8 & 0xFF;
        int b1 = c1 & 0xFF;
        int a2 = c2 >> 24 & 0xFF;
        int r2 = c2 >> 16 & 0xFF;
        int g2 = c2 >> 8 & 0xFF;
        int b2 = c2 & 0xFF;
        int a = (int)((float)a1 + (float)(a2 - a1) * progress);
        int r = (int)((float)r1 + (float)(r2 - r1) * progress);
        int g = (int)((float)g1 + (float)(g2 - g1) * progress);
        int b = (int)((float)b1 + (float)(b2 - b1) * progress);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int addAlpha(int color, float alpha) {
        int a = (int)(255.0f * alpha);
        return a << 24 | color & 0xFFFFFF;
    }
}

