/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.gui.widget.button.colorpicker;

import bookeditor.client.gui.widget.button.colorpicker.ColorPickerConstants;
import bookeditor.client.gui.widget.button.colorpicker.ColorPickerState;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class ColorPickerInputHandler {
    private final ColorPickerState state;
    private final Consumer<Integer> onColorChange;

    public ColorPickerInputHandler(ColorPickerState state, Consumer<Integer> onColorChange) {
        this.state = state;
        this.onColorChange = onColorChange;
    }

    public boolean handleMouseClick(double mouseX, double mouseY, int dropX, int dropY) {
        if (!this.state.expanded) {
            return false;
        }
        int paletteX = dropX + 2;
        int paletteY = dropY + 2;
        if (mouseX >= (double)paletteX && mouseX < (double)(paletteX + 124) && mouseY >= (double)paletteY && mouseY < (double)(paletteY + 80)) {
            this.state.draggingPalette = true;
            this.updateFromPalette(mouseX, mouseY, paletteX, paletteY);
            return true;
        }
        int hueX = paletteX + 124 + 2;
        if (mouseX >= (double)hueX && mouseX < (double)(hueX + 12) && mouseY >= (double)paletteY && mouseY < (double)(paletteY + 80)) {
            this.state.draggingHue = true;
            this.updateFromHueBar(mouseY, paletteY);
            return true;
        }
        int hexY = paletteY + 80 + 2;
        if (mouseX >= (double)paletteX && mouseX < (double)(paletteX + 80) && mouseY >= (double)hexY && mouseY < (double)(hexY + 18)) {
            this.state.hexFieldFocused = true;
            this.state.cursorPos = this.state.hexInput.length();
            this.state.cursorVisible = true;
            this.state.lastBlinkTime = System.currentTimeMillis();
            return true;
        }
        this.state.hexFieldFocused = false;
        int totalWidth = ColorPickerConstants.calculateTotalWidth();
        int totalHeight = ColorPickerConstants.calculateTotalHeight();
        if (mouseX < (double)dropX || mouseX >= (double)(dropX + totalWidth) || mouseY < (double)dropY || mouseY >= (double)(dropY + totalHeight)) {
            this.state.expanded = false;
            this.state.hexFieldFocused = false;
            return false;
        }
        return true;
    }

    public boolean handleMouseDrag(double mouseX, double mouseY, int dropX, int dropY) {
        if (!this.state.expanded) {
            return false;
        }
        int paletteX = dropX + 2;
        int paletteY = dropY + 2;
        if (this.state.draggingPalette) {
            this.updateFromPalette(mouseX, mouseY, paletteX, paletteY);
            return true;
        }
        if (this.state.draggingHue) {
            this.updateFromHueBar(mouseY, paletteY);
            return true;
        }
        return false;
    }

    public void handleMouseRelease() {
        this.state.draggingPalette = false;
        this.state.draggingHue = false;
    }

    private void updateFromPalette(double mouseX, double mouseY, int paletteX, int paletteY) {
        float sat = (float)Math.max(0.0, Math.min(123.0, mouseX - (double)paletteX)) / 123.0f;
        float bright = 1.0f - (float)Math.max(0.0, Math.min(79.0, mouseY - (double)paletteY)) / 79.0f;
        this.state.saturation = sat;
        this.state.brightness = bright;
        this.state.updateFromHSB();
        this.onColorChange.accept(this.state.argb);
    }

    private void updateFromHueBar(double mouseY, int hueY) {
        this.state.hue = (float)Math.max(0.0, Math.min(79.0, mouseY - (double)hueY)) / 79.0f;
        this.state.updateFromHSB();
        this.onColorChange.accept(this.state.argb);
    }

    public boolean handleKeyPress(int keyCode, int scanCode, int modifiers) {
        if (!this.state.hexFieldFocused) {
            return false;
        }
        if (this.handleTextEditing(keyCode)) {
            return true;
        }
        if (this.handleCursorNavigation(keyCode)) {
            return true;
        }
        if (this.handleFieldControl(keyCode)) {
            return true;
        }
        return this.handleClipboardOperations(keyCode, modifiers);
    }

    private boolean handleTextEditing(int keyCode) {
        if (keyCode == 259) {
            if (this.state.cursorPos > 0 && !this.state.hexInput.isEmpty()) {
                this.state.hexInput = this.state.hexInput.substring(0, this.state.cursorPos - 1) + this.state.hexInput.substring(this.state.cursorPos);
                --this.state.cursorPos;
            }
            return true;
        }
        if (keyCode == 261) {
            if (this.state.cursorPos < this.state.hexInput.length()) {
                this.state.hexInput = this.state.hexInput.substring(0, this.state.cursorPos) + this.state.hexInput.substring(this.state.cursorPos + 1);
            }
            return true;
        }
        return false;
    }

    private boolean handleCursorNavigation(int keyCode) {
        if (keyCode == 263) {
            this.state.cursorPos = Math.max(0, this.state.cursorPos - 1);
            return true;
        }
        if (keyCode == 262) {
            this.state.cursorPos = Math.min(this.state.hexInput.length(), this.state.cursorPos + 1);
            return true;
        }
        if (keyCode == 268) {
            this.state.cursorPos = 0;
            return true;
        }
        if (keyCode == 269) {
            this.state.cursorPos = this.state.hexInput.length();
            return true;
        }
        return false;
    }

    private boolean handleFieldControl(int keyCode) {
        if (keyCode == 257 || keyCode == 335) {
            this.state.hexFieldFocused = false;
            this.tryApplyHex();
            return true;
        }
        if (keyCode == 256) {
            this.state.hexFieldFocused = false;
            return true;
        }
        return false;
    }

    private boolean handleClipboardOperations(int keyCode, int modifiers) {
        boolean isCtrlPressed;
        boolean bl = isCtrlPressed = (modifiers & 2) != 0;
        if (keyCode == 67 && isCtrlPressed) {
            this.copyToClipboard();
            return true;
        }
        if (keyCode == 86 && isCtrlPressed) {
            this.pasteFromClipboard();
            return true;
        }
        if (keyCode == 65 && isCtrlPressed) {
            this.state.cursorPos = this.state.hexInput.length();
            return true;
        }
        return false;
    }

    private void copyToClipboard() {
        if (!this.state.hexInput.isEmpty()) {
            class_310.method_1551().field_1774.method_1455("#" + this.state.hexInput);
        }
    }

    private void pasteFromClipboard() {
        String clipboard = class_310.method_1551().field_1774.method_1460();
        if (clipboard != null) {
            clipboard = clipboard.replace("#", "").toUpperCase();
            if (!(clipboard = clipboard.replaceAll("[^0-9A-F]", "")).isEmpty()) {
                String toInsert;
                this.state.hexInput = toInsert = clipboard.substring(0, Math.min(clipboard.length(), 6));
                this.state.cursorPos = toInsert.length();
                if (toInsert.length() == 6 || toInsert.length() == 3) {
                    this.tryApplyHex();
                }
            }
        }
    }

    public boolean handleCharTyped(char chr, int modifiers) {
        if (!this.state.hexFieldFocused) {
            return false;
        }
        if (chr >= '0' && chr <= '9' || chr >= 'a' && chr <= 'f' || chr >= 'A' && chr <= 'F') {
            if (this.state.hexInput.length() < 6) {
                char upper = Character.toUpperCase(chr);
                this.state.hexInput = this.state.hexInput.substring(0, this.state.cursorPos) + upper + this.state.hexInput.substring(this.state.cursorPos);
                ++this.state.cursorPos;
            }
            return true;
        }
        return false;
    }

    private void tryApplyHex() {
        if (this.state.hexInput.length() == 6) {
            try {
                int r = Integer.parseInt(this.state.hexInput.substring(0, 2), 16);
                int g = Integer.parseInt(this.state.hexInput.substring(2, 4), 16);
                int b = Integer.parseInt(this.state.hexInput.substring(4, 6), 16);
                this.state.updateFromArgb(0xFF000000 | r << 16 | g << 8 | b);
                this.onColorChange.accept(this.state.argb);
            }
            catch (NumberFormatException r) {}
        } else if (this.state.hexInput.length() == 3) {
            try {
                int r = Integer.parseInt(String.valueOf(this.state.hexInput.charAt(0)), 16);
                int g = Integer.parseInt(String.valueOf(this.state.hexInput.charAt(1)), 16);
                int b = Integer.parseInt(String.valueOf(this.state.hexInput.charAt(2)), 16);
                this.state.updateFromArgb(0xFF000000 | (r *= 17) << 16 | (g *= 17) << 8 | (b *= 17));
                this.onColorChange.accept(this.state.argb);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

