/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.gui.widget.editor;

import bookeditor.client.editor.input.EditorInputHandler;
import bookeditor.client.editor.input.EditorMouseHandler;
import bookeditor.client.editor.interaction.ImageInteraction;
import bookeditor.client.editor.interaction.TextBoxInteraction;
import bookeditor.client.editor.mode.EditorMode;
import bookeditor.client.editor.render.EditorRenderer;
import bookeditor.client.editor.render.TextBoxRenderer;
import bookeditor.client.editor.textbox.TextBoxCaret;
import bookeditor.client.editor.textbox.TextBoxEditOps;
import bookeditor.client.editor.tools.AdvancedDrawingTool;
import bookeditor.client.editor.tools.EraserTool;
import bookeditor.client.editor.tools.TextBoxCreationTool;
import bookeditor.client.gui.widget.editor.EditorWidget;
import bookeditor.data.BookData;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_327;

@Environment(value=EnvType.CLIENT)
public class EditorState {
    public static final int PAD_OUT = 8;
    public static final int PAD_IN = 8;
    public static final int LOGICAL_W = 960;
    public static final int LOGICAL_H = 600;
    public static final int MAX_TEXTBOX_CHARS = 5000;
    public final class_327 textRenderer;
    public final Consumer<String> onImageUrlSeen;
    public final Runnable onDirty;
    public boolean editable;
    public BookData.Page page;
    public EditorMode mode = EditorMode.OBJECT_MODE;
    public boolean bold;
    public boolean italic;
    public boolean underline;
    public int argb = -14671840;
    public float size = 1.0f;
    public int textBoxBgColor = 0xFFFFFF;
    public String plankType = "minecraft:dark_oak_planks";
    public int scrollY = 0;
    public String clipboard = "";
    public final TextBoxCaret textBoxCaret = new TextBoxCaret();
    public final ImageInteraction imageInteraction = new ImageInteraction();
    public final TextBoxInteraction textBoxInteraction = new TextBoxInteraction();
    public final TextBoxCreationTool textBoxCreationTool = new TextBoxCreationTool();
    public final EraserTool eraserTool = new EraserTool();
    public final AdvancedDrawingTool drawingTool = new AdvancedDrawingTool();
    public final TextBoxRenderer textBoxRenderer = new TextBoxRenderer();
    public final TextBoxEditOps textBoxOps = new TextBoxEditOps();
    public final EditorRenderer editorRenderer = new EditorRenderer();
    public final EditorInputHandler inputHandler = new EditorInputHandler(this);
    public final EditorMouseHandler mouseHandler = new EditorMouseHandler();
    private final EditorWidget widget;
    private String transientMessage = null;
    private long transientExpiryMillis = 0L;

    public EditorState(class_327 textRenderer, boolean editable, Consumer<String> onImageUrlSeen, Runnable onDirty, EditorWidget widget) {
        this.textRenderer = textRenderer;
        this.editable = editable;
        this.onImageUrlSeen = onImageUrlSeen;
        this.onDirty = onDirty;
        this.widget = widget;
    }

    public void setHeight(int height) {
        this.widget.setWidgetHeight(Math.max(40, height));
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.widget.field_22763 = editable;
    }

    public void setContent(BookData.Page page) {
        this.page = page;
        this.mode = EditorMode.OBJECT_MODE;
        this.textBoxCaret.reset();
        this.textBoxInteraction.clearSelection();
        this.imageInteraction.clearSelection();
        this.textBoxCreationTool.deactivate();
        this.drawingTool.setActive(false);
        this.eraserTool.setActive(false);
        this.scrollY = 0;
    }

    public int innerLeft() {
        return this.widget.method_46426() + 8;
    }

    public int innerTop() {
        return this.widget.method_46427() + 8;
    }

    public int innerW() {
        return Math.max(0, this.widget.method_25368() - 16);
    }

    public int innerH() {
        return Math.max(0, this.widget.method_25364() - 16);
    }

    public double scale() {
        double sw = (double)this.innerW() / 976.0;
        double sh = (double)this.innerH() / 616.0;
        return Math.max(0.1, Math.min(sw, sh));
    }

    public int canvasScreenLeft() {
        int scaledW = (int)Math.floor(this.scale() * 976.0);
        return this.innerLeft() + Math.max(0, (this.innerW() - scaledW) / 2);
    }

    public int canvasScreenTop() {
        int scaledH = (int)Math.floor(this.scale() * 616.0);
        return this.innerTop() + Math.max(0, (this.innerH() - scaledH) / 2);
    }

    public int contentScreenLeft() {
        return this.canvasScreenLeft() + (int)Math.round(this.scale() * 8.0);
    }

    public int contentScreenTop() {
        return this.canvasScreenTop() + (int)Math.round(this.scale() * 8.0);
    }

    public EditorWidget getWidget() {
        return this.widget;
    }

    public void setPlankType(String plankType) {
        this.plankType = plankType != null ? plankType : "minecraft:dark_oak_planks";
    }

    public void showTransientMessage(String msg, long durationMillis) {
        this.transientMessage = msg;
        this.transientExpiryMillis = System.currentTimeMillis() + durationMillis;
    }

    public String getTransientMessage() {
        if (this.transientMessage == null) {
            return null;
        }
        if (System.currentTimeMillis() > this.transientExpiryMillis) {
            this.transientMessage = null;
            return null;
        }
        return this.transientMessage;
    }
}

