/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.gui.components;

import bookeditor.client.gui.base.WidgetHost;
import bookeditor.client.gui.widget.button.CustomButton;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public class NavigationControls {
    private final CustomButton prevBtn;
    private final CustomButton nextBtn;
    private Runnable onPrev;
    private Runnable onNext;
    private int totalPages;
    private int currentPage;

    public NavigationControls(WidgetHost host, int x, int y, int btnHeight) {
        this.prevBtn = new CustomButton(x, y, 20, btnHeight, (class_2561)class_2561.method_43470((String)"\u25c0"), b -> {
            if (this.onPrev != null) {
                this.onPrev.run();
            }
        });
        this.prevBtn.field_22764 = false;
        host.addDrawable(this.prevBtn);
        this.nextBtn = new CustomButton(x + 24, y, 20, btnHeight, (class_2561)class_2561.method_43470((String)"\u25b6"), b -> {
            if (this.onNext != null) {
                this.onNext.run();
            }
        });
        this.nextBtn.field_22764 = false;
        host.addDrawable(this.nextBtn);
    }

    public void setOnPrev(Runnable onPrev) {
        this.onPrev = onPrev;
    }

    public void setOnNext(Runnable onNext) {
        this.onNext = onNext;
    }

    public void setTotalPages(int totalPages) {
        this.totalPages = Math.max(0, totalPages);
        this.updateButtons();
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = Math.max(0, Math.min(currentPage, this.totalPages - 1));
        this.updateButtons();
    }

    public void setVisible(boolean visible) {
        this.prevBtn.field_22764 = visible;
        this.nextBtn.field_22764 = visible;
        this.updateButtons();
    }

    private void updateButtons() {
        this.prevBtn.field_22763 = this.currentPage > 0;
        this.nextBtn.field_22763 = this.currentPage < this.totalPages - 1 && this.totalPages > 1;
    }
}

