/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.editor.input;

import bookeditor.client.editor.interaction.TextBoxInteraction;
import bookeditor.client.editor.mode.EditorMode;
import bookeditor.client.editor.textbox.StyleParams;
import bookeditor.client.editor.textbox.TextBoxCaret;
import bookeditor.client.gui.widget.editor.EditorState;
import bookeditor.data.BookData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class EditorInputHandler {
    private final EditorState state;

    public EditorInputHandler(EditorState state) {
        this.state = state;
    }

    public boolean handleCharTyped(EditorMode mode, BookData.Page page, TextBoxInteraction textBoxInteraction, TextBoxCaret textBoxCaret, StyleParams style, char chr) {
        if (mode != EditorMode.TEXT_MODE || !textBoxInteraction.isEditingText()) {
            return false;
        }
        int selectedIdx = textBoxInteraction.getSelectedTextBoxIndex();
        if (selectedIdx < 0 || selectedIdx >= page.nodes.size()) {
            return false;
        }
        BookData.Node node = page.nodes.get(selectedIdx);
        if (!(node instanceof BookData.TextBoxNode)) {
            return false;
        }
        BookData.TextBoxNode box = (BookData.TextBoxNode)node;
        if (chr == '\r') {
            chr = (char)10;
        }
        if (chr < ' ' && chr != '\n' && chr != '\t') {
            return false;
        }
        boolean ok = this.state.textBoxOps.insertChar(box, textBoxCaret, style, chr);
        if (!ok) {
            this.state.showTransientMessage("Content limit reached", 3000L);
            return false;
        }
        return true;
    }

    public boolean handleKeyPressed(EditorMode mode, BookData.Page page, TextBoxInteraction textBoxInteraction, TextBoxCaret textBoxCaret, int keyCode, int modifiers) {
        if (mode != EditorMode.TEXT_MODE || !textBoxInteraction.isEditingText()) {
            return false;
        }
        int selectedIdx = textBoxInteraction.getSelectedTextBoxIndex();
        if (selectedIdx < 0 || selectedIdx >= page.nodes.size()) {
            return false;
        }
        BookData.Node node = page.nodes.get(selectedIdx);
        if (!(node instanceof BookData.TextBoxNode)) {
            return false;
        }
        BookData.TextBoxNode box = (BookData.TextBoxNode)node;
        boolean ctrl = class_437.method_25441();
        if (ctrl && keyCode == 65) {
            textBoxCaret.selectAll(box);
            return true;
        }
        if (keyCode == 259) {
            this.state.textBoxOps.backspace(box, textBoxCaret);
            return true;
        }
        if (keyCode == 261) {
            this.state.textBoxOps.deleteForward(box, textBoxCaret);
            return true;
        }
        if (keyCode == 257 || keyCode == 335) {
            boolean ok = this.state.textBoxOps.insertChar(box, textBoxCaret, new StyleParams(false, false, false, -14671840, 1.0f), '\n');
            if (!ok) {
                this.state.showTransientMessage("Content limit reached", 3000L);
                return false;
            }
            return true;
        }
        if (keyCode == 263) {
            if ((modifiers & 1) != 0) {
                if (!textBoxCaret.hasSelection()) {
                    textBoxCaret.setAnchor(textBoxCaret.getCharIndex());
                }
                textBoxCaret.moveLeft(box);
            } else {
                textBoxCaret.moveLeft(box);
                textBoxCaret.clearSelection();
            }
            return true;
        }
        if (keyCode == 262) {
            if ((modifiers & 1) != 0) {
                if (!textBoxCaret.hasSelection()) {
                    textBoxCaret.setAnchor(textBoxCaret.getCharIndex());
                }
                textBoxCaret.moveRight(box);
            } else {
                textBoxCaret.moveRight(box);
                textBoxCaret.clearSelection();
            }
            return true;
        }
        return false;
    }
}

