/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.editor.interaction;

import bookeditor.data.BookData;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class ImageInteraction {
    private final List<Rect> imageRects = new ArrayList<Rect>();
    private int selectedImageIndex = -1;
    private int resizingHandle = -1;
    private boolean draggingImage = false;
    private int dragStartMouseX;
    private int dragStartMouseY;
    private int dragStartW;
    private int dragStartH;
    private int dragStartImgX;
    private int dragStartImgY;

    public void beginFrame() {
        this.imageRects.clear();
    }

    public void addImageRect(int x, int y, int w, int h, int nodeIndex) {
        Rect r = new Rect();
        r.x = x;
        r.y = y;
        r.w = w;
        r.h = h;
        r.nodeIndex = nodeIndex;
        this.imageRects.add(r);
    }

    public void clearSelection() {
        this.selectedImageIndex = -1;
        this.resizingHandle = -1;
        this.draggingImage = false;
    }

    public boolean mouseClicked(int mx, int my, boolean editable, Runnable pushSnapshotOnce, BookData.Page page) {
        if (page == null) {
            return false;
        }
        for (int i = this.imageRects.size() - 1; i >= 0; --i) {
            Rect r = this.imageRects.get(i);
            if (editable && this.inside(mx, my, r.x - 2, r.y - 2, 8, 8)) {
                this.select(page, r.nodeIndex, 0, mx, my, pushSnapshotOnce);
                return true;
            }
            if (editable && this.inside(mx, my, r.x + r.w - 6, r.y - 2, 8, 8)) {
                this.select(page, r.nodeIndex, 1, mx, my, pushSnapshotOnce);
                return true;
            }
            if (editable && this.inside(mx, my, r.x - 2, r.y + r.h - 6, 8, 8)) {
                this.select(page, r.nodeIndex, 2, mx, my, pushSnapshotOnce);
                return true;
            }
            if (editable && this.inside(mx, my, r.x + r.w - 6, r.y + r.h - 6, 8, 8)) {
                this.select(page, r.nodeIndex, 3, mx, my, pushSnapshotOnce);
                return true;
            }
            if (!this.inside(mx, my, r.x, r.y, r.w, r.h)) continue;
            this.selectedImageIndex = r.nodeIndex;
            if (editable) {
                pushSnapshotOnce.run();
                this.draggingImage = true;
                this.dragStartMouseX = mx;
                this.dragStartMouseY = my;
                BookData.ImageNode img = (BookData.ImageNode)page.nodes.get(this.selectedImageIndex);
                this.dragStartImgX = img.x;
                this.dragStartImgY = img.y;
                this.dragStartW = img.w;
                this.dragStartH = img.h;
            }
            return true;
        }
        return false;
    }

    public boolean mouseDragged(int mx, int my, boolean editable, double scale, BookData.Page page) {
        if (!editable || page == null) {
            return false;
        }
        if (this.selectedImageIndex < 0 || this.selectedImageIndex >= page.nodes.size()) {
            return false;
        }
        BookData.Node n = page.nodes.get(this.selectedImageIndex);
        if (!(n instanceof BookData.ImageNode)) {
            return false;
        }
        BookData.ImageNode img = (BookData.ImageNode)n;
        int dxl = (int)Math.round((double)(mx - this.dragStartMouseX) / scale);
        int dyl = (int)Math.round((double)(my - this.dragStartMouseY) / scale);
        if (this.resizingHandle >= 0) {
            int newW = this.dragStartW;
            int newH = this.dragStartH;
            int newX = this.dragStartImgX;
            int newY = this.dragStartImgY;
            switch (this.resizingHandle) {
                case 0: {
                    newW = Math.max(8, this.dragStartW - dxl);
                    newH = Math.max(8, this.dragStartH - dyl);
                    int right = this.dragStartImgX + this.dragStartW;
                    int bottom = this.dragStartImgY + this.dragStartH;
                    newX = right - newW;
                    newY = bottom - newH;
                    if (newX < 0) {
                        newW += newX;
                        newX = 0;
                    }
                    if (newY >= 0) break;
                    newH += newY;
                    newY = 0;
                    break;
                }
                case 1: {
                    newW = Math.max(8, this.dragStartW + dxl);
                    newH = Math.max(8, this.dragStartH - dyl);
                    int bottom = this.dragStartImgY + this.dragStartH;
                    newY = bottom - newH;
                    if (newY >= 0) break;
                    newH += newY;
                    newY = 0;
                    break;
                }
                case 2: {
                    newW = Math.max(8, this.dragStartW - dxl);
                    newH = Math.max(8, this.dragStartH + dyl);
                    int right = this.dragStartImgX + this.dragStartW;
                    newX = right - newW;
                    if (newX >= 0) break;
                    newW += newX;
                    newX = 0;
                    break;
                }
                case 3: {
                    newW = Math.max(8, this.dragStartW + dxl);
                    newH = Math.max(8, this.dragStartH + dyl);
                }
            }
            if (newX + newW > 960) {
                newW = 960 - newX;
            }
            if (newY + newH > 600) {
                newH = 600 - newY;
            }
            img.w = Math.max(8, newW);
            img.h = Math.max(8, newH);
            if (this.resizingHandle == 0 || this.resizingHandle == 2) {
                img.x = Math.max(0, newX);
            }
            if (this.resizingHandle == 0 || this.resizingHandle == 1) {
                img.y = Math.max(0, newY);
            }
            return true;
        }
        if (this.draggingImage) {
            int newX = this.dragStartImgX + dxl;
            int newY = this.dragStartImgY + dyl;
            int maxX = Math.max(0, 960 - img.w);
            int maxY = Math.max(0, 600 - img.h);
            img.x = Math.max(0, Math.min(newX, maxX));
            img.y = Math.max(0, Math.min(newY, maxY));
            return true;
        }
        return false;
    }

    public boolean mouseReleased() {
        boolean changed = false;
        if (this.resizingHandle >= 0) {
            this.resizingHandle = -1;
            changed = true;
        }
        if (this.draggingImage) {
            this.draggingImage = false;
            changed = true;
        }
        return changed;
    }

    public void renderSelectionHandles(class_332 ctx) {
        if (this.selectedImageIndex < 0) {
            return;
        }
        Rect r = null;
        for (int i = this.imageRects.size() - 1; i >= 0; --i) {
            if (this.imageRects.get((int)i).nodeIndex != this.selectedImageIndex) continue;
            r = this.imageRects.get(i);
            break;
        }
        if (r != null) {
            ctx.method_25294(r.x - 1, r.y - 1, r.x + r.w + 1, r.y + r.h + 1, -2013224705);
            this.drawHandle(ctx, r.x, r.y);
            this.drawHandle(ctx, r.x + r.w - 4, r.y);
            this.drawHandle(ctx, r.x, r.y + r.h - 4);
            this.drawHandle(ctx, r.x + r.w - 4, r.y + r.h - 4);
        }
    }

    private void select(BookData.Page page, int nodeIndex, int handle, int mx, int my, Runnable pushSnapshotOnce) {
        this.selectedImageIndex = nodeIndex;
        this.resizingHandle = handle;
        this.dragStartMouseX = mx;
        this.dragStartMouseY = my;
        BookData.ImageNode img = (BookData.ImageNode)page.nodes.get(nodeIndex);
        this.dragStartW = img.w;
        this.dragStartH = img.h;
        this.dragStartImgX = img.x;
        this.dragStartImgY = img.y;
        pushSnapshotOnce.run();
    }

    private boolean inside(int x, int y, int rx, int ry, int rw, int rh) {
        return x >= rx && x <= rx + rw && y >= ry && y <= ry + rh;
    }

    private void drawHandle(class_332 ctx, int x, int y) {
        ctx.method_25294(x, y, x + 4, y + 4, -1);
        ctx.method_25294(x + 1, y + 1, x + 3, y + 3, -16777216);
    }

    public int getSelectedImageIndex() {
        return this.selectedImageIndex;
    }

    public void deleteSelectedIfImage(BookData.Page page) {
        if (page == null) {
            return;
        }
        if (this.selectedImageIndex >= 0 && this.selectedImageIndex < page.nodes.size() && page.nodes.get(this.selectedImageIndex) instanceof BookData.ImageNode) {
            page.nodes.remove(this.selectedImageIndex);
            this.selectedImageIndex = -1;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Rect {
        public int x;
        public int y;
        public int w;
        public int h;
        public int nodeIndex;
    }
}

