/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.editor.interaction;

import bookeditor.data.BookData;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class TextBoxInteraction {
    private final List<Rect> textBoxRects = new ArrayList<Rect>();
    private int selectedTextBoxIndex = -1;
    private int resizingHandle = -1;
    private boolean draggingTextBox = false;
    private boolean editingText = false;
    private int dragStartMouseX;
    private int dragStartMouseY;
    private int dragStartW;
    private int dragStartH;
    private int dragStartX;
    private int dragStartY;

    public void beginFrame() {
        this.textBoxRects.clear();
    }

    public void addTextBoxRect(int x, int y, int w, int h, int nodeIndex) {
        Rect r = new Rect();
        r.x = x;
        r.y = y;
        r.w = w;
        r.h = h;
        r.nodeIndex = nodeIndex;
        this.textBoxRects.add(r);
    }

    public void clearSelection() {
        this.selectedTextBoxIndex = -1;
        this.resizingHandle = -1;
        this.draggingTextBox = false;
        this.editingText = false;
    }

    public boolean isEditingText() {
        return this.editingText;
    }

    public void setEditingText(boolean editing) {
        this.editingText = editing;
    }

    public int getSelectedTextBoxIndex() {
        return this.selectedTextBoxIndex;
    }

    public boolean mouseClicked(int mx, int my, boolean editable, Runnable pushSnapshotOnce, BookData.Page page) {
        if (page == null) {
            return false;
        }
        for (int i = this.textBoxRects.size() - 1; i >= 0; --i) {
            Rect r = this.textBoxRects.get(i);
            if (editable && !this.editingText) {
                if (this.inside(mx, my, r.x - 2, r.y - 2, 8, 8)) {
                    this.select(page, r.nodeIndex, 0, mx, my, pushSnapshotOnce);
                    return true;
                }
                if (this.inside(mx, my, r.x + r.w - 6, r.y - 2, 8, 8)) {
                    this.select(page, r.nodeIndex, 1, mx, my, pushSnapshotOnce);
                    return true;
                }
                if (this.inside(mx, my, r.x - 2, r.y + r.h - 6, 8, 8)) {
                    this.select(page, r.nodeIndex, 2, mx, my, pushSnapshotOnce);
                    return true;
                }
                if (this.inside(mx, my, r.x + r.w - 6, r.y + r.h - 6, 8, 8)) {
                    this.select(page, r.nodeIndex, 3, mx, my, pushSnapshotOnce);
                    return true;
                }
            }
            if (!this.inside(mx, my, r.x, r.y, r.w, r.h)) continue;
            this.selectedTextBoxIndex = r.nodeIndex;
            if (editable && !this.editingText) {
                pushSnapshotOnce.run();
                this.draggingTextBox = true;
                this.dragStartMouseX = mx;
                this.dragStartMouseY = my;
                BookData.TextBoxNode box = (BookData.TextBoxNode)page.nodes.get(this.selectedTextBoxIndex);
                this.dragStartX = box.x;
                this.dragStartY = box.y;
                this.dragStartW = box.width;
                this.dragStartH = box.height;
            }
            return true;
        }
        return false;
    }

    public boolean mouseDragged(int mx, int my, boolean editable, double scale, BookData.Page page) {
        if (!editable || page == null || this.editingText) {
            return false;
        }
        if (this.selectedTextBoxIndex < 0 || this.selectedTextBoxIndex >= page.nodes.size()) {
            return false;
        }
        BookData.Node n = page.nodes.get(this.selectedTextBoxIndex);
        if (!(n instanceof BookData.TextBoxNode)) {
            return false;
        }
        BookData.TextBoxNode box = (BookData.TextBoxNode)n;
        int dxl = (int)Math.round((double)(mx - this.dragStartMouseX) / scale);
        int dyl = (int)Math.round((double)(my - this.dragStartMouseY) / scale);
        if (this.resizingHandle >= 0) {
            int newW = this.dragStartW;
            int newH = this.dragStartH;
            int newX = this.dragStartX;
            int newY = this.dragStartY;
            switch (this.resizingHandle) {
                case 0: {
                    newW = Math.max(50, this.dragStartW - dxl);
                    newH = Math.max(30, this.dragStartH - dyl);
                    int right = this.dragStartX + this.dragStartW;
                    int bottom = this.dragStartY + this.dragStartH;
                    newX = right - newW;
                    newY = bottom - newH;
                    if (newX < 0) {
                        newW += newX;
                        newX = 0;
                    }
                    if (newY >= 0) break;
                    newH += newY;
                    newY = 0;
                    break;
                }
                case 1: {
                    newW = Math.max(50, this.dragStartW + dxl);
                    newH = Math.max(30, this.dragStartH - dyl);
                    int bottom = this.dragStartY + this.dragStartH;
                    newY = bottom - newH;
                    if (newY >= 0) break;
                    newH += newY;
                    newY = 0;
                    break;
                }
                case 2: {
                    newW = Math.max(50, this.dragStartW - dxl);
                    newH = Math.max(30, this.dragStartH + dyl);
                    int right = this.dragStartX + this.dragStartW;
                    newX = right - newW;
                    if (newX >= 0) break;
                    newW += newX;
                    newX = 0;
                    break;
                }
                case 3: {
                    newW = Math.max(50, this.dragStartW + dxl);
                    newH = Math.max(30, this.dragStartH + dyl);
                }
            }
            if (newX + newW > 960) {
                newW = 960 - newX;
            }
            if (newY + newH > 600) {
                newH = 600 - newY;
            }
            box.width = Math.max(50, newW);
            box.height = Math.max(30, newH);
            if (this.resizingHandle == 0 || this.resizingHandle == 2) {
                box.x = Math.max(0, newX);
            }
            if (this.resizingHandle == 0 || this.resizingHandle == 1) {
                box.y = Math.max(0, newY);
            }
            return true;
        }
        if (this.draggingTextBox) {
            int newX = this.dragStartX + dxl;
            int newY = this.dragStartY + dyl;
            int maxX = Math.max(0, 960 - box.width);
            int maxY = Math.max(0, 600 - box.height);
            box.x = Math.max(0, Math.min(newX, maxX));
            box.y = Math.max(0, Math.min(newY, maxY));
            return true;
        }
        return false;
    }

    public boolean mouseReleased() {
        boolean changed = false;
        if (this.resizingHandle >= 0) {
            this.resizingHandle = -1;
            changed = true;
        }
        if (this.draggingTextBox) {
            this.draggingTextBox = false;
            changed = true;
        }
        return changed;
    }

    public void renderSelectionHandles(class_332 ctx) {
        if (this.selectedTextBoxIndex < 0) {
            return;
        }
        Rect r = null;
        for (int i = this.textBoxRects.size() - 1; i >= 0; --i) {
            if (this.textBoxRects.get((int)i).nodeIndex != this.selectedTextBoxIndex) continue;
            r = this.textBoxRects.get(i);
            break;
        }
        if (r != null) {
            int borderColor = this.editingText ? -2013200640 : -2013224705;
            ctx.method_25294(r.x - 1, r.y - 1, r.x + r.w + 1, r.y, borderColor);
            ctx.method_25294(r.x - 1, r.y + r.h, r.x + r.w + 1, r.y + r.h + 1, borderColor);
            ctx.method_25294(r.x - 1, r.y, r.x, r.y + r.h, borderColor);
            ctx.method_25294(r.x + r.w, r.y, r.x + r.w + 1, r.y + r.h, borderColor);
            if (!this.editingText) {
                this.drawHandle(ctx, r.x, r.y);
                this.drawHandle(ctx, r.x + r.w - 4, r.y);
                this.drawHandle(ctx, r.x, r.y + r.h - 4);
                this.drawHandle(ctx, r.x + r.w - 4, r.y + r.h - 4);
            }
        }
    }

    public void deleteSelectedIfTextBox(BookData.Page page) {
        if (page == null) {
            return;
        }
        if (this.selectedTextBoxIndex >= 0 && this.selectedTextBoxIndex < page.nodes.size() && page.nodes.get(this.selectedTextBoxIndex) instanceof BookData.TextBoxNode) {
            page.nodes.remove(this.selectedTextBoxIndex);
            this.selectedTextBoxIndex = -1;
            this.editingText = false;
        }
    }

    private void select(BookData.Page page, int nodeIndex, int handle, int mx, int my, Runnable pushSnapshotOnce) {
        this.selectedTextBoxIndex = nodeIndex;
        this.resizingHandle = handle;
        this.dragStartMouseX = mx;
        this.dragStartMouseY = my;
        BookData.TextBoxNode box = (BookData.TextBoxNode)page.nodes.get(nodeIndex);
        this.dragStartW = box.width;
        this.dragStartH = box.height;
        this.dragStartX = box.x;
        this.dragStartY = box.y;
        pushSnapshotOnce.run();
    }

    private boolean inside(int x, int y, int rx, int ry, int rw, int rh) {
        return x >= rx && x <= rx + rw && y >= ry && y <= ry + rh;
    }

    private void drawHandle(class_332 ctx, int x, int y) {
        ctx.method_25294(x, y, x + 4, y + 4, -1);
        ctx.method_25294(x + 1, y + 1, x + 3, y + 3, -16750900);
    }

    @Environment(value=EnvType.CLIENT)
    public static class Rect {
        public int x;
        public int y;
        public int w;
        public int h;
        public int nodeIndex;
    }
}

