/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.editor.render;

import bookeditor.client.editor.interaction.ImageInteraction;
import bookeditor.client.util.ImageCache;
import bookeditor.data.BookData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class ImageRenderer {
    public void render(class_332 ctx, BookData.Page page, ImageInteraction imageInteraction, int startScreenX, int startScreenY, int canvasScreenTop, double scale, int logicalW, int logicalH) {
        if (page == null) {
            return;
        }
        for (int i = 0; i < page.nodes.size(); ++i) {
            BookData.Node n = page.nodes.get(i);
            if (!(n instanceof BookData.ImageNode)) continue;
            BookData.ImageNode img = (BookData.ImageNode)n;
            int drawW = Math.max(8, img.w);
            int drawH = Math.max(8, img.h);
            int imgX = startScreenX + (int)Math.round(scale * (double)img.x);
            int imgY = startScreenY + (int)Math.round(scale * (double)img.y);
            class_2960 tex = ImageCache.getTexture(img.url);
            boolean texReady = tex != null && class_310.method_1551().method_1531().method_4619(tex) != null;
            int sw = Math.max(1, (int)Math.round(scale * (double)drawW));
            int sh = Math.max(1, (int)Math.round(scale * (double)drawH));
            if (imgY < canvasScreenTop + (int)Math.floor(scale * (double)(logicalH + 16)) && imgY + sh > canvasScreenTop) {
                if (texReady) {
                    ctx.method_25290(tex, imgX, imgY, 0.0f, 0.0f, sw, sh, sw, sh);
                } else {
                    ctx.method_25294(imgX, imgY, imgX + sw, imgY + sh, -3355444);
                }
            }
            imageInteraction.addImageRect(imgX, imgY, sw, sh, i);
        }
    }
}

