/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.editor.render;

import bookeditor.client.editor.textbox.TextBoxCaret;
import bookeditor.data.BookData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class TextBoxRenderer {
    public CaretPosition render(class_332 ctx, class_327 textRenderer, BookData.TextBoxNode textBox, TextBoxCaret caret, int screenX, int screenY, double scale, boolean showCaret, boolean showSelection) {
        CaretPosition caretPos = new CaretPosition();
        caretPos.x = 0;
        caretPos.y = 0;
        caretPos.textSize = 1.0f;
        if (textBox == null) {
            return caretPos;
        }
        Objects.requireNonNull(textRenderer);
        int baseLineHeight = 9;
        int selStart = showSelection && caret.hasSelection() ? caret.selectionStart() : -1;
        int selEnd = showSelection && caret.hasSelection() ? caret.selectionEnd() : -1;
        ctx.method_44379(screenX, screenY, screenX + (int)((double)textBox.width * scale), screenY + (int)((double)textBox.height * scale));
        List<LineInfo> lines = this.buildLines(textRenderer, textBox);
        int currentY = 0;
        boolean caretFound = false;
        for (int lineIdx = 0; lineIdx < lines.size(); ++lineIdx) {
            int offsetX;
            LineInfo line = lines.get(lineIdx);
            int lineHeight = (int)Math.ceil((float)baseLineHeight * line.maxSize * 1.2f);
            if (currentY + lineHeight > textBox.height) break;
            int currentX = offsetX = this.calculateAlignOffset(line.align, line.width, textBox.width);
            if (line.chars.isEmpty()) {
                if (showCaret && !caretFound) {
                    int totalCharsBeforeLine = this.getTotalCharsBeforeLine(lines, lineIdx);
                    if (caret.getCharIndex() == totalCharsBeforeLine) {
                        caretPos.x = offsetX;
                        caretPos.y = currentY;
                        caretPos.textSize = line.maxSize;
                        caretFound = true;
                    }
                }
                currentY += lineHeight;
                continue;
            }
            for (CharInfo charInfo : line.chars) {
                if (showCaret && !caretFound && charInfo.globalCharIndex == caret.getCharIndex()) {
                    caretPos.x = currentX;
                    caretPos.y = currentY;
                    caretPos.textSize = charInfo.segment.size;
                    caretFound = true;
                }
                if (showSelection && charInfo.globalCharIndex >= selStart && charInfo.globalCharIndex < selEnd) {
                    int sx = screenX + (int)((double)currentX * scale);
                    int sy = screenY + (int)((double)currentY * scale);
                    int sw = Math.max(1, (int)((double)charInfo.width * scale));
                    int sh = (int)((double)lineHeight * scale);
                    ctx.method_25294(sx, sy, sx + sw, sy + sh, 1429446911);
                }
                class_2583 style = class_2583.field_24360.method_10982(Boolean.valueOf(charInfo.segment.bold)).method_10978(Boolean.valueOf(charInfo.segment.italic)).method_30938(Boolean.valueOf(charInfo.segment.underline)).method_36139(charInfo.segment.argb & 0xFFFFFF);
                ctx.method_51448().method_22903();
                ctx.method_51448().method_22904((double)screenX + (double)currentX * scale, (double)screenY + (double)currentY * scale, 0.0);
                ctx.method_51448().method_22905((float)(scale * (double)charInfo.segment.size), (float)(scale * (double)charInfo.segment.size), 1.0f);
                ctx.method_51439(textRenderer, (class_2561)class_2561.method_43470((String)String.valueOf(charInfo.ch)).method_10862(style), 0, 0, charInfo.segment.argb & 0xFFFFFF, false);
                ctx.method_51448().method_22909();
                currentX += charInfo.width;
            }
            if (!line.chars.isEmpty()) {
                CharInfo lastChar = line.chars.get(line.chars.size() - 1);
                if (showCaret && !caretFound && lastChar.globalCharIndex + 1 == caret.getCharIndex()) {
                    caretPos.x = currentX;
                    caretPos.y = currentY;
                    caretPos.textSize = lastChar.segment.size;
                    caretFound = true;
                }
            }
            currentY += lineHeight;
        }
        if (showCaret && !caretFound) {
            int totalChars = this.getTotalChars(lines);
            if (caret.getCharIndex() >= totalChars) {
                if (lines.isEmpty() || lines.size() == 1 && lines.get((int)0).chars.isEmpty()) {
                    caretPos.x = 0;
                    caretPos.y = 0;
                    caretPos.textSize = 1.0f;
                } else {
                    LineInfo lastLine = lines.get(lines.size() - 1);
                    int lastLineY = currentY - (int)Math.ceil((float)baseLineHeight * lastLine.maxSize * 1.2f);
                    if (lastLine.chars.isEmpty()) {
                        caretPos.x = this.calculateAlignOffset(lastLine.align, 0, textBox.width);
                        caretPos.y = lastLineY;
                        caretPos.textSize = lastLine.maxSize;
                    } else {
                        CharInfo lastChar = lastLine.chars.get(lastLine.chars.size() - 1);
                        int offsetX = this.calculateAlignOffset(lastLine.align, lastLine.width, textBox.width);
                        caretPos.x = offsetX + lastLine.width;
                        caretPos.y = lastLineY;
                        caretPos.textSize = lastChar.segment.size;
                    }
                }
            }
        }
        ctx.method_44380();
        return caretPos;
    }

    private int getTotalChars(List<LineInfo> lines) {
        int total = 0;
        for (LineInfo line : lines) {
            total += line.chars.size();
        }
        return total;
    }

    private int getTotalCharsBeforeLine(List<LineInfo> lines, int lineIndex) {
        int total = 0;
        for (int i = 0; i < lineIndex && i < lines.size(); ++i) {
            total += lines.get((int)i).chars.size();
        }
        return total;
    }

    private List<LineInfo> buildLines(class_327 textRenderer, BookData.TextBoxNode textBox) {
        ArrayList<LineInfo> lines = new ArrayList<LineInfo>();
        if (textBox.segments.isEmpty()) {
            LineInfo emptyLine = new LineInfo();
            emptyLine.maxSize = 1.0f;
            emptyLine.align = 0;
            lines.add(emptyLine);
            return lines;
        }
        boolean hasAnyText = false;
        for (BookData.TextSegment seg : textBox.segments) {
            if (seg.text.isEmpty()) continue;
            hasAnyText = true;
            break;
        }
        if (!hasAnyText) {
            LineInfo emptyLine = new LineInfo();
            emptyLine.maxSize = textBox.segments.isEmpty() ? 1.0f : textBox.segments.get((int)0).size;
            emptyLine.align = textBox.segments.isEmpty() ? 0 : textBox.segments.get((int)0).align;
            lines.add(emptyLine);
            return lines;
        }
        LineInfo currentLine = new LineInfo();
        int globalCharIndex = 0;
        for (BookData.TextSegment seg : textBox.segments) {
            currentLine.maxSize = Math.max(currentLine.maxSize, seg.size);
            if (seg.text.isEmpty()) continue;
            for (int i = 0; i < seg.text.length(); ++i) {
                char ch = seg.text.charAt(i);
                if (ch == '\n') {
                    currentLine.align = seg.align;
                    lines.add(currentLine);
                    currentLine = new LineInfo();
                    currentLine.maxSize = seg.size;
                    ++globalCharIndex;
                    continue;
                }
                int charWidth = (int)Math.ceil((float)textRenderer.method_1727(String.valueOf(ch)) * seg.size);
                if (currentLine.width + charWidth > textBox.width && !currentLine.chars.isEmpty()) {
                    currentLine.align = seg.align;
                    lines.add(currentLine);
                    currentLine = new LineInfo();
                    currentLine.maxSize = seg.size;
                }
                CharInfo charInfo = new CharInfo();
                charInfo.ch = ch;
                charInfo.width = charWidth;
                charInfo.segment = seg;
                charInfo.globalCharIndex = globalCharIndex++;
                currentLine.chars.add(charInfo);
                currentLine.width += charWidth;
                currentLine.maxSize = Math.max(currentLine.maxSize, seg.size);
            }
        }
        if (!currentLine.chars.isEmpty()) {
            if (!textBox.segments.isEmpty()) {
                currentLine.align = textBox.segments.get((int)(textBox.segments.size() - 1)).align;
            }
            lines.add(currentLine);
        } else if (lines.isEmpty()) {
            LineInfo emptyLine = new LineInfo();
            emptyLine.maxSize = 1.0f;
            emptyLine.align = 0;
            lines.add(emptyLine);
        }
        return lines;
    }

    private int calculateAlignOffset(int align, int lineWidth, int boxWidth) {
        switch (align) {
            case 1: {
                return Math.max(0, (boxWidth - lineWidth) / 2);
            }
            case 2: {
                return Math.max(0, boxWidth - lineWidth);
            }
        }
        return 0;
    }

    public int getCharIndexAtPosition(class_327 textRenderer, BookData.TextBoxNode textBox, int localX, int localY) {
        if (textBox == null) {
            return 0;
        }
        Objects.requireNonNull(textRenderer);
        int baseLineHeight = 9;
        List<LineInfo> lines = this.buildLines(textRenderer, textBox);
        int currentY = 0;
        for (int lineIdx = 0; lineIdx < lines.size(); ++lineIdx) {
            LineInfo line = lines.get(lineIdx);
            int lineHeight = (int)Math.ceil((float)baseLineHeight * line.maxSize * 1.2f);
            if (localY >= currentY && localY < currentY + lineHeight) {
                int offsetX;
                int currentX = offsetX = this.calculateAlignOffset(line.align, line.width, textBox.width);
                if (line.chars.isEmpty()) {
                    return this.getTotalCharsBeforeLine(lines, lineIdx);
                }
                for (CharInfo charInfo : line.chars) {
                    if (localX < currentX + charInfo.width / 2) {
                        return charInfo.globalCharIndex;
                    }
                    currentX += charInfo.width;
                }
                return line.chars.get((int)(line.chars.size() - 1)).globalCharIndex + 1;
            }
            currentY += lineHeight;
        }
        return this.getTotalChars(lines);
    }

    @Environment(value=EnvType.CLIENT)
    public static class CaretPosition {
        public int x;
        public int y;
        public float textSize = 1.0f;
    }

    @Environment(value=EnvType.CLIENT)
    private static class LineInfo {
        List<CharInfo> chars = new ArrayList<CharInfo>();
        int width = 0;
        int align = 0;
        float maxSize = 1.0f;

        private LineInfo() {
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class CharInfo {
        char ch;
        int width;
        BookData.TextSegment segment;
        int globalCharIndex;

        private CharInfo() {
        }
    }
}

