/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.editor.textbox;

import bookeditor.data.BookData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class TextBoxCaret {
    private int charIndex = 0;
    private int selectionAnchor = -1;

    public void reset() {
        this.charIndex = 0;
        this.clearSelection();
    }

    public int getCharIndex() {
        return this.charIndex;
    }

    public void setCharIndex(int index) {
        this.charIndex = Math.max(0, index);
    }

    public void setAnchor(int index) {
        this.selectionAnchor = index;
    }

    public void clearSelection() {
        this.selectionAnchor = -1;
    }

    public boolean hasSelection() {
        return this.selectionAnchor >= 0 && this.selectionAnchor != this.charIndex;
    }

    public int selectionStart() {
        if (!this.hasSelection()) {
            return this.charIndex;
        }
        return Math.min(this.selectionAnchor, this.charIndex);
    }

    public int selectionEnd() {
        if (!this.hasSelection()) {
            return this.charIndex;
        }
        return Math.max(this.selectionAnchor, this.charIndex);
    }

    public void moveLeft(BookData.TextBoxNode textBox) {
        if (textBox == null) {
            return;
        }
        String fullText = textBox.getFullText();
        if (this.charIndex > 0) {
            --this.charIndex;
        }
    }

    public void moveRight(BookData.TextBoxNode textBox) {
        if (textBox == null) {
            return;
        }
        String fullText = textBox.getFullText();
        if (this.charIndex < fullText.length()) {
            ++this.charIndex;
        }
    }

    public void selectAll(BookData.TextBoxNode textBox) {
        if (textBox == null) {
            return;
        }
        this.selectionAnchor = 0;
        this.charIndex = textBox.getFullText().length();
    }

    public void ensureWithinBounds(BookData.TextBoxNode textBox) {
        if (textBox == null) {
            this.charIndex = 0;
            return;
        }
        int maxIndex = textBox.getFullText().length();
        this.charIndex = Math.max(0, Math.min(this.charIndex, maxIndex));
    }
}

