/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.editor.tools;

import bookeditor.data.BookData;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class EraserTool {
    private boolean active = false;
    private int eraserSize = 10;

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setSize(int size) {
        this.eraserSize = Math.max(5, Math.min(50, size));
    }

    public int getSize() {
        return this.eraserSize;
    }

    public void erase(BookData.Page page, int mx, int my, int contentLeft, int contentTop, double scale, int scrollY) {
        if (!this.active || page == null) {
            return;
        }
        int localX = (int)Math.floor((double)(mx - contentLeft) / scale);
        int localY = (int)Math.floor((double)(my - contentTop) / scale) + scrollY;
        for (BookData.Stroke stroke : new ArrayList<BookData.Stroke>(page.strokes)) {
            stroke.points.removeIf(p -> {
                int dx = p.x - localX;
                int dy = p.y - localY;
                return Math.sqrt(dx * dx + dy * dy) < (double)this.eraserSize;
            });
            if (!stroke.points.isEmpty()) continue;
            page.strokes.remove(stroke);
        }
    }

    public void renderPreview(class_332 ctx, int mx, int my, int contentLeft, int contentTop, double scale, int scrollY) {
    }
}

