/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.editor.tools;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class TextBoxCreationTool {
    private boolean active = false;
    private int previewX = 0;
    private int previewY = 0;
    private int previewWidth = 300;
    private int previewHeight = 100;

    public void activate() {
        this.active = true;
    }

    public void deactivate() {
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    public void updatePreview(int mouseX, int mouseY, int contentLeft, int contentTop, double scale, int scrollY) {
        if (!this.active) {
            return;
        }
        int localX = (int)Math.floor((double)(mouseX - contentLeft) / scale);
        int localY = (int)Math.floor((double)(mouseY - contentTop) / scale) + scrollY;
        this.previewX = Math.max(0, Math.min(localX - this.previewWidth / 2, 960 - this.previewWidth));
        this.previewY = Math.max(0, Math.min(localY - this.previewHeight / 2, 600 - this.previewHeight));
    }

    public void renderPreview(class_332 ctx, int contentLeft, int contentTop, double scale, int scrollY) {
        if (!this.active) {
            return;
        }
        int screenX = contentLeft + (int)Math.round(scale * (double)this.previewX);
        int screenY = contentTop + (int)Math.round(scale * (double)(this.previewY - scrollY));
        int screenW = (int)Math.round(scale * (double)this.previewWidth);
        int screenH = (int)Math.round(scale * (double)this.previewHeight);
        ctx.method_25294(screenX, screenY, screenX + screenW, screenY + screenH, 0x4400FF00);
        ctx.method_25294(screenX, screenY, screenX + screenW, screenY + 2, -2013200640);
        ctx.method_25294(screenX, screenY + screenH - 2, screenX + screenW, screenY + screenH, -2013200640);
        ctx.method_25294(screenX, screenY, screenX + 2, screenY + screenH, -2013200640);
        ctx.method_25294(screenX + screenW - 2, screenY, screenX + screenW, screenY + screenH, -2013200640);
    }

    public int getPreviewX() {
        return this.previewX;
    }

    public int getPreviewY() {
        return this.previewY;
    }

    public int getPreviewWidth() {
        return this.previewWidth;
    }

    public int getPreviewHeight() {
        return this.previewHeight;
    }
}

