/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.gui.components;

import bookeditor.client.gui.base.WidgetHost;
import bookeditor.client.gui.widget.button.CustomButton;
import bookeditor.client.gui.widget.button.IconButton;
import bookeditor.client.gui.widget.field.NumericTextField;
import bookeditor.client.util.IconUtils;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class BookNavigator {
    private final WidgetHost host;
    private final int screenWidth;
    private final int y;
    private final int btnH;
    private final IntSupplier getCurrentPage;
    private final IntSupplier getTotalPages;
    private final IntConsumer setPage;
    private CustomButton prevBtn;
    private NumericTextField pageField;
    private CustomButton nextBtn;

    public BookNavigator(WidgetHost host, int screenWidth, int y, int btnH, IntSupplier getCurrentPage, IntSupplier getTotalPages, IntConsumer setPage) {
        this.host = host;
        this.screenWidth = screenWidth;
        this.y = y;
        this.btnH = btnH;
        this.getCurrentPage = getCurrentPage;
        this.getTotalPages = getTotalPages;
        this.setPage = setPage;
    }

    public void build() {
        int margin = 10;
        String maxPages = "/ 999";
        int totalPagesTextWidth = this.host.getTextRenderer().method_1727(maxPages);
        int totalWidth = 59 + totalPagesTextWidth + 5 + 18 + 3 + 20;
        int cx = this.screenWidth - margin - totalWidth;
        this.prevBtn = new CustomButton(cx, this.y, 20, this.btnH, (class_2561)class_2561.method_43470((String)"\u25c0"), b -> {
            int current = this.getCurrentPage.getAsInt();
            if (current > 0) {
                this.setPage.accept(current - 1);
            }
        });
        this.host.addDrawable(this.prevBtn);
        this.pageField = new NumericTextField(this.host.getTextRenderer(), cx += 23, this.y, 36, this.btnH, (class_2561)class_2561.method_43470((String)""));
        this.pageField.method_1852(String.valueOf(this.getCurrentPage.getAsInt() + 1));
        this.pageField.method_1880(4);
        this.pageField.setOnEnterPressed(this::handlePageFieldSubmit);
        this.host.addDrawable(this.pageField);
        IconButton goBtn = new IconButton(cx += 36 + totalPagesTextWidth + 5, this.y, 18, this.btnH, IconUtils.ICON_APPLY, (class_2561)class_2561.method_43471((String)"tooltip.bookeditor.go_to_page"), b -> this.handlePageFieldSubmit());
        this.host.addDrawable(goBtn);
        this.nextBtn = new CustomButton(cx += 21, this.y, 20, this.btnH, (class_2561)class_2561.method_43470((String)"\u25b6"), b -> {
            int current = this.getCurrentPage.getAsInt();
            if (current < this.getTotalPages.getAsInt() - 1) {
                this.setPage.accept(current + 1);
            }
        });
        this.host.addDrawable(this.nextBtn);
    }

    public void updateState() {
        if (this.pageField != null) {
            this.pageField.method_1852(String.valueOf(this.getCurrentPage.getAsInt() + 1));
        }
        if (this.prevBtn != null) {
            boolean bl = this.prevBtn.field_22763 = this.getCurrentPage.getAsInt() > 0;
        }
        if (this.nextBtn != null) {
            this.nextBtn.field_22763 = this.getCurrentPage.getAsInt() < this.getTotalPages.getAsInt() - 1;
        }
    }

    public void handlePageFieldSubmit() {
        if (this.pageField == null) {
            return;
        }
        try {
            int page = Integer.parseInt(this.pageField.method_1882()) - 1;
            if (page >= 0 && page < this.getTotalPages.getAsInt()) {
                this.setPage.accept(page);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.updateState();
    }

    public void renderPageCounter(class_332 ctx, class_327 textRenderer, int totalPages) {
        if (this.pageField == null) {
            return;
        }
        String counter = "/ " + totalPages;
        int counterX = this.pageField.method_46426() + this.pageField.method_25368() + 5;
        int counterY = this.pageField.method_46427() + (this.pageField.method_25364() - 8) / 2;
        ctx.method_51439(textRenderer, (class_2561)class_2561.method_43470((String)counter), counterX, counterY, -2039584, false);
    }
}

