/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.gui.components;

import bookeditor.client.editor.tools.DrawingTool;
import bookeditor.client.gui.base.WidgetHost;
import bookeditor.client.gui.components.SectionBuildResult;
import bookeditor.client.gui.components.ToolbarSection;
import bookeditor.client.gui.components.ToolbarSectionBuilder;
import bookeditor.client.gui.widget.button.ColorPickerDropdown;
import bookeditor.client.gui.widget.button.IconButton;
import bookeditor.client.gui.widget.editor.EditorWidget;
import bookeditor.client.gui.widget.field.NumericTextField;
import bookeditor.client.util.IconUtils;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_7919;

@Environment(value=EnvType.CLIENT)
public class DrawingToolsSectionBuilder
implements ToolbarSectionBuilder {
    @Override
    public SectionBuildResult build(WidgetHost host, EditorWidget editor, Runnable onDirty, IntSupplier getCanvasColor, Consumer<Integer> setCanvasColor, Runnable openInsertDialog, Runnable createNewPage, Runnable deleteCurrentPage, Runnable signAction, int btnH) {
        ToolbarSection section = new ToolbarSection("Drawing");
        IconButton brush = new IconButton(0, 0, 18, btnH, IconUtils.ICON_BRUSH, (class_2561)class_2561.method_43471((String)"tooltip.bookeditor.brush"), b -> {
            editor.setDrawingTool(DrawingTool.BRUSH);
            onDirty.run();
        });
        brush.field_22764 = true;
        host.addDrawable(brush);
        section.addWidget((Object)brush, 18);
        IconButton spray = new IconButton(0, 0, 18, btnH, IconUtils.ICON_SPRAY, (class_2561)class_2561.method_43471((String)"tooltip.bookeditor.spray"), b -> {
            editor.setDrawingTool(DrawingTool.SPRAY);
            onDirty.run();
        });
        spray.field_22764 = true;
        host.addDrawable(spray);
        section.addWidget((Object)spray, 18);
        IconButton line = new IconButton(0, 0, 18, btnH, IconUtils.ICON_LINE, (class_2561)class_2561.method_43471((String)"tooltip.bookeditor.line"), b -> {
            editor.setDrawingTool(DrawingTool.LINE);
            onDirty.run();
        });
        line.field_22764 = true;
        host.addDrawable(line);
        section.addWidget((Object)line, 18);
        IconButton rectangle = new IconButton(0, 0, 18, btnH, IconUtils.ICON_RECTANGLE, (class_2561)class_2561.method_43471((String)"tooltip.bookeditor.rectangle"), b -> {
            editor.setDrawingTool(DrawingTool.RECTANGLE);
            onDirty.run();
        });
        rectangle.field_22764 = true;
        host.addDrawable(rectangle);
        section.addWidget((Object)rectangle, 18);
        IconButton circle = new IconButton(0, 0, 18, btnH, IconUtils.ICON_CIRCLE, (class_2561)class_2561.method_43471((String)"tooltip.bookeditor.circle"), b -> {
            editor.setDrawingTool(DrawingTool.CIRCLE);
            onDirty.run();
        });
        circle.field_22764 = true;
        host.addDrawable(circle);
        section.addWidget((Object)circle, 18);
        IconButton eraser = new IconButton(0, 0, 18, btnH, IconUtils.ICON_ERASER, (class_2561)class_2561.method_43471((String)"tooltip.bookeditor.eraser"), b -> {
            editor.setDrawingTool(DrawingTool.ERASER);
            onDirty.run();
        });
        eraser.field_22764 = true;
        host.addDrawable(eraser);
        section.addWidget((Object)eraser, 18);
        ColorPickerDropdown toolColor = new ColorPickerDropdown(0, 0, argb -> {
            editor.setDrawingToolColor((int)argb);
            onDirty.run();
        }, -16777216);
        toolColor.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"tooltip.bookeditor.tool_color")));
        host.addDrawable(toolColor);
        section.addWidget((Object)toolColor, 20);
        NumericTextField toolSize = new NumericTextField(host.getTextRenderer(), 0, 0, 36, btnH, (class_2561)class_2561.method_43471((String)"tooltip.bookeditor.tool_size"));
        toolSize.method_1852("3");
        toolSize.setOnEnterPressed(() -> {
            try {
                int px = Integer.parseInt(toolSize.method_1882().trim());
                px = Math.max(1, Math.min(50, px));
                editor.setToolSize(px);
                toolSize.method_1852(String.valueOf(px));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        host.addDrawable(toolSize);
        section.addWidget((Object)toolSize, 36);
        SectionBuildResult res = new SectionBuildResult(section);
        res.with("brushBtn", (Object)brush).with("sprayBtn", (Object)spray).with("lineBtn", (Object)line).with("rectangleBtn", (Object)rectangle).with("circleBtn", (Object)circle).with("eraserBtn", (Object)eraser).with("toolColorBtn", (Object)toolColor).with("toolSizeField", (Object)toolSize);
        return res;
    }
}

