/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.gui.components;

import bookeditor.client.gui.base.WidgetHost;
import bookeditor.client.gui.components.NavigationControls;
import bookeditor.client.gui.components.ToolbarSection;
import bookeditor.client.gui.components.ToolbarWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ToolbarPager {
    private final int x;
    private final int y;
    private final int gap;
    private final int availableWidth;
    private final NavigationControls navigation;
    private final Consumer<Integer> onPageChanged;
    private final List<ToolbarSection> sections = new ArrayList<ToolbarSection>();
    private final List<List<ToolbarWidget>> pages = new ArrayList<List<ToolbarWidget>>();
    private int currentPage = 0;

    public ToolbarPager(WidgetHost host, int x, int y, int btnH, int gap, int availableWidth, Consumer<Integer> onPageChanged) {
        this.x = x;
        this.y = y;
        this.gap = gap;
        this.availableWidth = availableWidth;
        this.onPageChanged = onPageChanged;
        this.navigation = new NavigationControls(host, x, y, btnH);
        this.navigation.setOnPrev(() -> {
            if (this.currentPage > 0) {
                this.showPage(this.currentPage - 1);
            }
        });
        this.navigation.setOnNext(() -> {
            if (this.currentPage < this.pages.size() - 1) {
                this.showPage(this.currentPage + 1);
            }
        });
        this.navigation.setVisible(false);
    }

    public void setSections(List<ToolbarSection> sections) {
        this.sections.clear();
        this.sections.addAll(sections);
        this.buildPages();
    }

    private void buildPages() {
        this.pages.clear();
        int navButtonsWidth = 48;
        int usableWidth = this.availableWidth - navButtonsWidth - 20;
        ArrayList<ToolbarWidget> current = new ArrayList<ToolbarWidget>();
        int currentWidth = 0;
        for (ToolbarSection section : this.sections) {
            int sectionWidth = section.getTotalWidth(this.gap);
            if (currentWidth > 0 && currentWidth + sectionWidth + 10 > usableWidth) {
                this.pages.add(current);
                current = new ArrayList();
                currentWidth = 0;
            }
            if (currentWidth > 0) {
                currentWidth += 10;
            }
            current.addAll(section.widgets);
            currentWidth += sectionWidth;
        }
        if (!current.isEmpty()) {
            this.pages.add(current);
        }
        this.navigation.setTotalPages(this.pages.size());
        if (this.currentPage >= this.pages.size()) {
            this.currentPage = Math.max(0, this.pages.size() - 1);
        }
    }

    public void showPage(int pageIndex) {
        if (this.pages.isEmpty()) {
            return;
        }
        if (pageIndex < 0 || pageIndex >= this.pages.size()) {
            return;
        }
        this.currentPage = pageIndex;
        for (ToolbarSection section : this.sections) {
            for (ToolbarWidget w : section.widgets) {
                w.setVisible(false);
            }
        }
        List<ToolbarWidget> pageWidgets = this.pages.get(pageIndex);
        int cx = this.x + 48;
        for (ToolbarWidget w : pageWidgets) {
            w.setPosition(cx, this.y);
            w.setVisible(true);
            cx += w.getWidth() + this.gap;
        }
        this.navigation.setCurrentPage(this.currentPage);
        if (this.onPageChanged != null) {
            this.onPageChanged.accept(this.currentPage);
        }
    }

    public void setVisible(boolean visible) {
        this.navigation.setVisible(visible);
        if (!visible) {
            for (ToolbarSection section : this.sections) {
                for (ToolbarWidget w : section.widgets) {
                    w.setVisible(false);
                }
            }
        } else {
            this.showPage(this.currentPage);
        }
    }
}

