/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.gui.screen;

import bookeditor.client.gui.base.WidgetHost;
import bookeditor.client.gui.components.AdaptiveToolbar;
import bookeditor.client.gui.components.BookNavigator;
import bookeditor.client.gui.render.AuthorBadgeRenderer;
import bookeditor.client.gui.render.LimitBadgeRenderer;
import bookeditor.client.gui.screen.ImageInsertScreen;
import bookeditor.client.gui.util.UiUtils;
import bookeditor.client.gui.widget.button.ColorPickerDropdown;
import bookeditor.client.gui.widget.editor.EditorWidget;
import bookeditor.client.gui.widget.field.CustomTextField;
import bookeditor.client.net.BookSyncService;
import bookeditor.client.util.ImageCache;
import bookeditor.data.BookData;
import bookeditor.data.NbtSizeUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class BookScreen
extends class_437
implements WidgetHost {
    private static final int MARGIN = 10;
    private static final int GAP = 5;
    private static final int BTN_H = 18;
    private final class_1268 hand;
    private final BookData data;
    private int bookPage = 0;
    private CustomTextField titleField;
    private EditorWidget editor;
    private BookNavigator bookNavigator;
    private AdaptiveToolbar toolbar;
    private boolean nbtTooLarge = false;
    private long currentNbtSize = 0L;
    private long nbtMax = NbtSizeUtils.getAllowedMax();
    private boolean debugNbtOverlay = false;

    public BookScreen(class_1799 stack, class_1268 hand) {
        super((class_2561)class_2561.method_43471((String)"screen.bookeditor.title"));
        this.hand = hand;
        this.data = BookData.readFrom(stack);
        if (this.data.pages.isEmpty()) {
            BookData.Page p = new BookData.Page();
            p.nodes.add(new BookData.TextNode("", false, false, false, -14671840, 1.0f, 0));
            this.data.pages.add(p);
        }
    }

    protected void method_25426() {
        this.method_37067();
        int y = 10;
        if (!this.data.signed) {
            int titleW = Math.min(220, this.field_22789 / 4);
            this.titleField = new CustomTextField(this.field_22793, 10, y, titleW, 18, (class_2561)class_2561.method_43471((String)"screen.bookeditor.book_title"));
            this.titleField.method_1852(this.data.title);
            this.method_37063((class_364)this.titleField);
        }
        this.bookNavigator = new BookNavigator(this, this.field_22789, y, 18, () -> this.bookPage, this.data.pages::size, this::setPage);
        this.bookNavigator.build();
        int toolbarY = y += 23;
        int toolbarWidth = this.field_22789 - 20;
        int editorY = y += 23;
        int editorWidth = this.field_22789 - 20;
        int editorHeight = Math.max(160, this.field_22790 - editorY - 10);
        this.editor = new EditorWidget(this.field_22793, 10, editorY, editorWidth, editorHeight, !this.data.signed, ImageCache::requestTexture, this::onDirty);
        this.method_37063((class_364)this.editor);
        this.toolbar = new AdaptiveToolbar(this, this.editor, this::onDirty, () -> this.data.pages.get((int)this.bookPage).bgArgb, this::setPageBgColor, this::openInsertDialog, this::createNewPage, this::deleteCurrentPage, this::signBook, 10, toolbarY, 18, 5, toolbarWidth);
        this.toolbar.build();
        this.editor.setContent(this.data.pages.get(this.bookPage));
        this.updateUI();
        this.updateNbtFlags();
    }

    private void updateNbtFlags() {
        class_2487 nbt = BookData.toNbt(this.data);
        int size = NbtSizeUtils.measureNbtInPacket(this.hand, nbt);
        if (size < 0 && (size = NbtSizeUtils.getNbtByteSize(nbt)) < 0) {
            class_2540 tmp = PacketByteBufs.create();
            tmp.method_10794(nbt);
            size = tmp.readableBytes();
        }
        this.currentNbtSize = size;
        this.nbtMax = NbtSizeUtils.getAllowedMax();
        if ((long)size > this.nbtMax) {
            this.setNbtTooLarge(true);
        } else if (this.nbtTooLarge) {
            this.setNbtTooLarge(false);
        }
    }

    private void updateUI() {
        boolean editable;
        if (this.bookNavigator != null) {
            this.bookNavigator.updateState();
        }
        boolean bl = editable = !this.data.signed && !this.nbtTooLarge;
        if (this.toolbar != null) {
            this.toolbar.setVisible(editable);
        }
        if (this.editor != null) {
            this.editor.setEditable(editable);
        }
        if (this.titleField != null) {
            this.titleField.field_22764 = editable;
        }
        this.prefetchPageImages();
    }

    public void setNbtTooLarge(boolean v) {
        this.nbtTooLarge = v;
        this.updateUI();
    }

    private void setPage(int page) {
        if (page < 0 || page >= this.data.pages.size()) {
            return;
        }
        this.bookPage = page;
        this.editor.setContent(this.data.pages.get(this.bookPage));
        this.toolbar.updateCanvasColor(this.data.pages.get((int)this.bookPage).bgArgb);
        this.bookNavigator.updateState();
        this.prefetchPageImages();
    }

    private void setPageBgColor(int color) {
        if (this.bookPage >= 0 && this.bookPage < this.data.pages.size()) {
            this.data.pages.get((int)this.bookPage).bgArgb = color;
            this.onDirty();
        }
    }

    private void prefetchPageImages() {
        BookData.Page p = this.data.pages.get(this.bookPage);
        for (BookData.Node n : p.nodes) {
            if (!(n instanceof BookData.ImageNode)) continue;
            BookData.ImageNode img = (BookData.ImageNode)n;
            if (img.url == null || img.url.isEmpty()) continue;
            ImageCache.requestTexture(img.url);
        }
    }

    private void openInsertDialog() {
        if (this.data.signed) {
            return;
        }
        class_310.method_1551().method_1507((class_437)new ImageInsertScreen(this, (url, w, h, isGifIgnored) -> {
            this.editor.markSnapshot();
            this.editor.insertImage(url, w, h, false);
            this.onDirty();
        }, false));
    }

    private void createNewPage() {
        if (this.data.signed) {
            return;
        }
        BookData.Page p = new BookData.Page();
        BookData.Page cur = this.data.pages.get(this.bookPage);
        p.bgArgb = cur.bgArgb;
        p.nodes.add(new BookData.TextNode("", false, false, false, -14671840, 1.0f, 0));
        this.data.pages.add(this.bookPage + 1, p);
        this.setPage(this.bookPage + 1);
        this.onDirty();
    }

    private void deleteCurrentPage() {
        if (this.data.signed || this.data.pages.size() <= 1) {
            return;
        }
        this.data.pages.remove(this.bookPage);
        int newIndex = Math.max(0, Math.min(this.bookPage, this.data.pages.size() - 1));
        this.setPage(newIndex);
        this.onDirty();
    }

    private void signBook() {
        class_746 player;
        if (this.data.signed) {
            return;
        }
        if (this.titleField != null) {
            this.data.title = this.titleField.method_1882();
        }
        if ((player = class_310.method_1551().field_1724) != null) {
            this.data.authorName = player.method_7334().getName();
            this.data.authorUuid = player.method_5667();
            this.data.signed = true;
            this.updateUI();
            this.onDirty();
        }
    }

    private void onDirty() {
        block5: {
            this.updateNbtFlags();
            if (this.nbtTooLarge) {
                return;
            }
            if (!this.data.signed && this.titleField != null) {
                this.data.title = this.titleField.method_1882();
            }
            try {
                BookSyncService.sendUpdate(this.hand, this.data);
            }
            catch (Exception ex) {
                if (this.editor != null) {
                    this.editor.showTransientMessage(class_2561.method_43471((String)"screen.bookeditor.failed_save").getString(), 5000L);
                }
                if (ex.getMessage() == null || !ex.getMessage().contains("too large")) break block5;
                this.setNbtTooLarge(true);
            }
        }
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        this.method_25420(ctx);
        super.method_25394(ctx, mouseX, mouseY, delta);
        if (this.data.signed) {
            AuthorBadgeRenderer.renderBadge(ctx, this.field_22793, this.field_22789, 20, 18, this.data);
        }
        LimitBadgeRenderer.renderLimit(ctx, this.field_22793, this.field_22789, 20, 18, this.data, this.nbtTooLarge);
        if (this.debugNbtOverlay) {
            String cur = UiUtils.humanReadableBytes(this.currentNbtSize);
            String max = UiUtils.humanReadableBytes(this.nbtMax);
            double frac = this.nbtMax > 0L ? (double)this.currentNbtSize / (double)this.nbtMax : 0.0;
            int pct = (int)Math.round(frac * 100.0);
            String s = String.format("NBT: %s / %s (%d%%) - clientMax=%d, serverConst=%d", cur, max, pct, this.nbtMax, 0x200000);
            ctx.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)s), 8, 8, -256);
        }
        if (this.bookNavigator != null) {
            this.bookNavigator.renderPageCounter(ctx, this.field_22793, this.data.pages.size());
        }
        for (class_364 child : this.method_25396()) {
            ColorPickerDropdown dropdown;
            if (!(child instanceof ColorPickerDropdown) || !(dropdown = (ColorPickerDropdown)child).isExpanded()) continue;
            dropdown.renderDropdown(ctx, mouseX, mouseY);
        }
        if (this.toolbar != null && this.editor != null) {
            this.toolbar.syncWithEditor();
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (class_364 child : this.method_25396()) {
            ColorPickerDropdown dropdown;
            if (!(child instanceof ColorPickerDropdown) || !(dropdown = (ColorPickerDropdown)child).isExpanded() || !dropdown.method_25402(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25410(class_310 client, int width, int height) {
        super.method_25410(client, width, height);
    }

    public void method_25419() {
        this.onDirty();
        super.method_25419();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.data.signed && BookScreen.method_25441()) {
            if (keyCode == 78) {
                boolean shift;
                boolean bl = shift = (modifiers & 1) != 0;
                if (shift) {
                    this.debugNbtOverlay = !this.debugNbtOverlay;
                    return true;
                }
            }
            if (keyCode == 66) {
                this.editor.setBold(!this.editor.isBold());
                this.editor.applyStyleToSelection();
                this.toolbar.refreshFormatButtons();
                this.onDirty();
                return true;
            }
            if (keyCode == 73) {
                this.editor.setItalic(!this.editor.isItalic());
                this.editor.applyStyleToSelection();
                this.toolbar.refreshFormatButtons();
                this.onDirty();
                return true;
            }
            if (keyCode == 85) {
                this.editor.setUnderline(!this.editor.isUnderline());
                this.editor.applyStyleToSelection();
                this.toolbar.refreshFormatButtons();
                this.onDirty();
                return true;
            }
            if (keyCode == 90) {
                if (this.editor.undo()) {
                    this.onDirty();
                }
                return true;
            }
            if (keyCode == 89) {
                if (this.editor.redo()) {
                    this.onDirty();
                }
                return true;
            }
            if (keyCode == 67) {
                this.editor.copySelection();
                return true;
            }
            if (keyCode == 86) {
                this.editor.paste();
                this.onDirty();
                return true;
            }
            if (keyCode == 88) {
                this.editor.cutSelection();
                this.onDirty();
                return true;
            }
            if (keyCode == 65) {
                this.editor.selectAll();
                return true;
            }
        }
        if (!this.data.signed && (keyCode == 257 || keyCode == 335) && BookScreen.method_25441()) {
            this.signBook();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public <T extends class_364 & class_4068> T addDrawable(T widget) {
        return (T)this.method_37063(widget);
    }

    @Override
    public class_327 getTextRenderer() {
        return this.field_22793;
    }
}

