/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.gui.widget.button;

import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6381;
import net.minecraft.class_6382;

@Environment(value=EnvType.CLIENT)
public class ColorPickerDropdown
extends class_339 {
    private final Consumer<Integer> onColorChange;
    private int argb;
    private boolean expanded = false;
    private float hoverProgress = 0.0f;
    private long lastFrameTime = System.currentTimeMillis();
    private static final int[] PRESET_COLORS = new int[]{-16777216, -12566464, -8355712, -4144960, -1, -65536, Short.MIN_VALUE, -256, -8323328, -16711936, -16711808, -16711681, -16744193, -16776961, -8388353, -65281, -65408, -8388608, -8355840, -16744448, -16744320, -16777088, -8388480, -7650029, -23296};
    private static final int COLOR_SIZE = 16;
    private static final int GAP = 2;
    private static final int COLS = 5;

    public ColorPickerDropdown(int x, int y, Consumer<Integer> onColorChange, int initialArgb) {
        super(x, y, 20, 18, (class_2561)class_2561.method_43470((String)""));
        this.onColorChange = onColorChange;
        this.argb = initialArgb;
    }

    public void setArgb(int argb) {
        this.argb = argb;
    }

    public int getArgb() {
        return this.argb;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    protected void method_48579(class_332 ctx, int mouseX, int mouseY, float delta) {
        long currentTime = System.currentTimeMillis();
        float deltaTime = (float)(currentTime - this.lastFrameTime) / 1000.0f;
        this.lastFrameTime = currentTime;
        boolean isHovering = this.method_49606();
        if (isHovering && this.hoverProgress < 1.0f) {
            this.hoverProgress = Math.min(1.0f, this.hoverProgress + deltaTime * 5.0f);
        } else if (!isHovering && this.hoverProgress > 0.0f) {
            this.hoverProgress = Math.max(0.0f, this.hoverProgress - deltaTime * 5.0f);
        }
        int x = this.method_46426();
        int y = this.method_46427();
        int w = this.field_22758;
        int h = this.field_22759;
        ctx.method_25294(x + 1, y + h, x + w - 1, y + h + 1, 0x33000000);
        ctx.method_25294(x + 2, y + 2, x + w - 2, y + h - 2, this.argb);
        int borderBrightness = (int)(100.0f + 55.0f * this.hoverProgress);
        int borderColor = 0xFF000000 | borderBrightness << 16 | borderBrightness << 8 | borderBrightness;
        ctx.method_25294(x, y, x + w, y + 2, borderColor);
        ctx.method_25294(x, y + h - 2, x + w, y + h, borderColor);
        ctx.method_25294(x, y, x + 2, y + h, borderColor);
        ctx.method_25294(x + w - 2, y, x + w, y + h, borderColor);
        int topGradient = this.addAlpha(-1, 0.2f * (1.0f + this.hoverProgress * 0.3f));
        ctx.method_25294(x + 2, y + 2, x + w - 2, y + h / 2, topGradient);
    }

    public void renderDropdown(class_332 ctx, int mouseX, int mouseY) {
        if (!this.expanded) {
            return;
        }
        int rows = (PRESET_COLORS.length + 5 - 1) / 5;
        int dropWidth = 92;
        int dropHeight = rows * 16 + (rows + 1) * 2;
        int dropX = this.method_46426();
        int dropY = this.method_46427() + this.field_22759 + 2;
        ctx.method_51448().method_22903();
        ctx.method_51448().method_46416(0.0f, 0.0f, 300.0f);
        ctx.method_25294(dropX - 1, dropY - 1, dropX + dropWidth + 1, dropY + dropHeight + 1, -14803426);
        ctx.method_25294(dropX, dropY, dropX + dropWidth, dropY + dropHeight, -13816528);
        for (int i = 0; i < PRESET_COLORS.length; ++i) {
            int col = i % 5;
            int row = i / 5;
            int cx = dropX + 2 + col * 18;
            int cy = dropY + 2 + row * 18;
            ctx.method_25294(cx, cy, cx + 16, cy + 16, PRESET_COLORS[i]);
            if (mouseX < cx || mouseX >= cx + 16 || mouseY < cy || mouseY >= cy + 16) continue;
            ctx.method_25294(cx, cy, cx + 16, cy + 1, -1);
            ctx.method_25294(cx, cy + 16 - 1, cx + 16, cy + 16, -1);
            ctx.method_25294(cx, cy, cx + 1, cy + 16, -1);
            ctx.method_25294(cx + 16 - 1, cy, cx + 16, cy + 16, -1);
        }
        ctx.method_51448().method_22909();
    }

    public void method_25348(double mouseX, double mouseY) {
        if (this.expanded) {
            int rows = (PRESET_COLORS.length + 5 - 1) / 5;
            int dropWidth = 92;
            int dropHeight = rows * 16 + (rows + 1) * 2;
            int dropX = this.method_46426();
            int dropY = this.method_46427() + this.field_22759 + 2;
            if (mouseX >= (double)dropX && mouseX < (double)(dropX + dropWidth) && mouseY >= (double)dropY && mouseY < (double)(dropY + dropHeight)) {
                for (int i = 0; i < PRESET_COLORS.length; ++i) {
                    int col = i % 5;
                    int row = i / 5;
                    int cx = dropX + 2 + col * 18;
                    int cy = dropY + 2 + row * 18;
                    if (!(mouseX >= (double)cx) || !(mouseX < (double)(cx + 16)) || !(mouseY >= (double)cy) || !(mouseY < (double)(cy + 16))) continue;
                    this.argb = PRESET_COLORS[i];
                    this.onColorChange.accept(this.argb);
                    this.expanded = false;
                    return;
                }
            }
            this.expanded = false;
        } else {
            this.expanded = true;
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.expanded) {
            int rows = (PRESET_COLORS.length + 5 - 1) / 5;
            int dropWidth = 92;
            int dropHeight = rows * 16 + (rows + 1) * 2;
            int dropX = this.method_46426();
            int dropY = this.method_46427() + this.field_22759 + 2;
            if (mouseX >= (double)dropX && mouseX < (double)(dropX + dropWidth) && mouseY >= (double)dropY && mouseY < (double)(dropY + dropHeight)) {
                this.method_25348(mouseX, mouseY);
                return true;
            }
            this.expanded = false;
            return false;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private int addAlpha(int color, float alpha) {
        int a = (int)(255.0f * alpha);
        return a << 24 | color & 0xFFFFFF;
    }

    protected void method_47399(class_6382 builder) {
        builder.method_37034(class_6381.field_33788, (class_2561)class_2561.method_43471((String)"narrator.select.color"));
    }
}

