/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.gui.widget.editor;

import bookeditor.client.editor.history.HistoryManager;
import bookeditor.client.editor.mode.EditorMode;
import bookeditor.client.gui.widget.editor.EditorState;
import bookeditor.data.BookData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;

@Environment(value=EnvType.CLIENT)
public class EditorHistoryManager {
    private final HistoryManager history = new HistoryManager();
    private final EditorState state;

    public EditorHistoryManager(EditorState state) {
        this.state = state;
    }

    public void pushSnapshot() {
        if (this.state.page == null) {
            return;
        }
        this.history.pushSnapshot(this.state.page::toNbt);
    }

    public void pushSnapshotOnce() {
        if (this.state.page != null) {
            this.history.pushSnapshotOnce(this.state.page::toNbt);
        }
    }

    public boolean undo() {
        boolean result = this.history.undo(this::applySnapshot);
        if (result) {
            this.state.editorRenderer.resetCaretBlink();
        }
        return result;
    }

    public boolean redo() {
        boolean result = this.history.redo(this::applySnapshot);
        if (result) {
            this.state.editorRenderer.resetCaretBlink();
        }
        return result;
    }

    public void onContentSet() {
        this.history.clear();
        this.pushSnapshot();
        this.state.editorRenderer.resetCaretBlink();
        if (this.state.onImageUrlSeen != null && this.state.page != null) {
            for (BookData.Node n : this.state.page.nodes) {
                if (!(n instanceof BookData.ImageNode)) continue;
                BookData.ImageNode img = (BookData.ImageNode)n;
                if (img.url == null || img.url.isEmpty()) continue;
                this.state.onImageUrlSeen.accept(img.url);
            }
        }
    }

    private void applySnapshot(class_2487 snap) {
        BookData.Page restored = BookData.Page.fromNbt(snap.method_10553());
        this.state.page.nodes.clear();
        this.state.page.strokes.clear();
        this.state.page.bgArgb = restored.bgArgb;
        this.state.page.nodes.addAll(restored.nodes);
        this.state.page.strokes.addAll(restored.strokes);
        this.state.imageInteraction.clearSelection();
        this.state.textBoxInteraction.clearSelection();
        this.state.textBoxCaret.clearSelection();
        this.state.textBoxCreationTool.deactivate();
        this.state.mode = EditorMode.OBJECT_MODE;
        if (this.state.onImageUrlSeen != null) {
            for (BookData.Node n : this.state.page.nodes) {
                if (!(n instanceof BookData.ImageNode)) continue;
                BookData.ImageNode img = (BookData.ImageNode)n;
                if (img.url == null || img.url.isEmpty()) continue;
                this.state.onImageUrlSeen.accept(img.url);
            }
        }
    }

    public void notifyDirty() {
        this.history.resetSnapshotArmed();
        if (this.state.onDirty != null) {
            this.state.onDirty.run();
        }
    }
}

