/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.gui.widget.editor;

import bookeditor.client.gui.widget.editor.EditorState;
import bookeditor.client.gui.widget.editor.EditorStyleManager;
import bookeditor.client.gui.widget.editor.EditorToolManager;
import bookeditor.client.gui.widget.editor.EditorWidget;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class EditorRendererManager {
    private final EditorState state;

    public EditorRendererManager(EditorState state, EditorToolManager toolManager, EditorStyleManager styleManager) {
        this.state = state;
    }

    public void renderButton(class_332 ctx, int mouseX, int mouseY, float delta) {
        EditorWidget widget = this.state.getWidget();
        this.renderFrame(ctx, widget);
        this.renderCanvas(ctx);
        this.enableScissor(ctx);
        if (this.state.textBoxCreationTool.isActive()) {
            this.state.textBoxCreationTool.updatePreview(mouseX, mouseY, this.state.contentScreenLeft(), this.state.contentScreenTop(), this.state.scale(), this.state.scrollY);
        }
        this.state.editorRenderer.render(ctx, this.state.page, this.state.mode, this.state.imageInteraction, this.state.textBoxInteraction, this.state.textBoxCaret, this.state.textRenderer, widget.method_25370(), this.state.editable, this.state.contentScreenLeft(), this.state.contentScreenTop(), this.state.canvasScreenTop(), this.state.scale(), this.state.scrollY, 960, 600);
        this.state.drawingTool.renderStrokes(ctx, this.state.page, this.state.contentScreenLeft(), this.state.contentScreenTop(), this.state.scale(), this.state.scrollY);
        this.state.imageInteraction.renderSelectionHandles(ctx);
        this.state.textBoxInteraction.renderSelectionHandles(ctx);
        if (this.state.textBoxCreationTool.isActive()) {
            this.state.textBoxCreationTool.renderPreview(ctx, this.state.contentScreenLeft(), this.state.contentScreenTop(), this.state.scale(), this.state.scrollY);
        }
        if (this.state.eraserTool.isActive()) {
            this.state.eraserTool.renderPreview(ctx, mouseX, mouseY, this.state.contentScreenLeft(), this.state.contentScreenTop(), this.state.scale(), this.state.scrollY);
        }
        ctx.method_44380();
        String msg = this.state.getTransientMessage();
        if (msg != null) {
            int centerX = widget.method_46426() + widget.method_25368() / 2;
            int textY = widget.method_46427() + 6;
            int textW = this.state.textRenderer.method_1727(msg);
            ctx.method_51439(this.state.textRenderer, (class_2561)class_2561.method_43470((String)msg), centerX - textW / 2, textY, -2039584, false);
        }
    }

    private void renderFrame(class_332 ctx, EditorWidget widget) {
        int frame = widget.method_49606() ? -5592406 : -4276546;
        ctx.method_25294(widget.method_46426() - 1, widget.method_46427() - 1, widget.method_46426() + widget.method_25368() + 1, widget.method_46427() + widget.method_25364() + 1, frame);
        ctx.method_25294(widget.method_46426(), widget.method_46427(), widget.method_46426() + widget.method_25368(), widget.method_46427() + widget.method_25364(), -1052689);
    }

    private void renderCanvas(class_332 ctx) {
        int cLeft = this.state.canvasScreenLeft();
        int cTop = this.state.canvasScreenTop();
        int scaledW = (int)Math.floor(this.state.scale() * 976.0);
        int scaledH = (int)Math.floor(this.state.scale() * 616.0);
        int bg = this.state.page != null ? this.state.page.bgArgb : -460552;
        ctx.method_25294(cLeft, cTop, cLeft + scaledW, cTop + scaledH, bg);
        ctx.method_25294(cLeft - 1, cTop - 1, cLeft + scaledW + 1, cTop, 0x33000000);
        ctx.method_25294(cLeft - 1, cTop + scaledH, cLeft + scaledW + 1, cTop + scaledH + 1, 0x33000000);
        ctx.method_25294(cLeft - 1, cTop, cLeft, cTop + scaledH, 0x33000000);
        ctx.method_25294(cLeft + scaledW, cTop, cLeft + scaledW + 1, cTop + scaledH, 0x33000000);
    }

    private void enableScissor(class_332 ctx) {
        int cLeft = this.state.canvasScreenLeft();
        int cTop = this.state.canvasScreenTop();
        int scaledW = (int)Math.floor(this.state.scale() * 976.0);
        int scaledH = (int)Math.floor(this.state.scale() * 616.0);
        int scLeft = Math.max(this.state.innerLeft(), cLeft);
        int scTop = Math.max(this.state.innerTop(), cTop);
        int scRight = Math.min(this.state.innerLeft() + this.state.innerW(), cLeft + scaledW);
        int scBottom = Math.min(this.state.innerTop() + this.state.innerH(), cTop + scaledH);
        if (scRight > scLeft && scBottom > scTop) {
            ctx.method_44379(scLeft, scTop, scRight, scBottom);
        }
    }
}

