/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.data;

import bookeditor.data.BookDataModelAdapter;
import bookeditor.data.BookDataSerializer;
import bookeditor.data.model.NodeModel;
import bookeditor.data.model.PageModel;
import bookeditor.data.model.StrokeModel;
import bookeditor.data.model.TextSegmentModel;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public class BookData {
    public static final String ROOT = "CreativeBook";
    public static final String PAGES = "pages";
    public static final String TITLE = "title";
    public static final String AUTHOR_NAME = "authorName";
    public static final String AUTHOR_UUID = "authorUuid";
    public static final String SIGNED = "signed";
    public String title = "";
    public String authorName = "";
    public UUID authorUuid = class_156.field_25140;
    public boolean signed = false;
    public final List<Page> pages = new ArrayList<Page>();
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;

    public static void ensureDefaults(class_1799 stack, class_1657 player) {
        BookDataSerializer.ensureDefaults(stack, player);
    }

    public static BookData readFrom(class_1799 stack) {
        return BookDataSerializer.readFrom(stack);
    }

    public static void writeTo(class_1799 stack, BookData data) {
        BookDataSerializer.writeTo(stack, data);
    }

    public static class_2487 toNbt(BookData d) {
        return BookDataSerializer.toNbt(d);
    }

    public static class Stroke {
        public int color = -16777216;
        public int thickness = 2;
        public final List<Point> points = new ArrayList<Point>();

        public class_2487 toNbt() {
            return BookDataModelAdapter.toModel(this).toNbt();
        }

        public static Stroke fromNbt(class_2487 c) {
            return BookDataModelAdapter.fromModel(StrokeModel.fromNbt(c));
        }

        public static class Point {
            public int x;
            public int y;

            public Point(int x, int y) {
                this.x = x;
                this.y = y;
            }
        }
    }

    public static class ImageNode
    extends Node {
        public String url;
        public int w;
        public int h;
        public boolean gif;
        public int align = 0;
        public boolean absolute = true;
        public int x = 0;
        public int y = 0;

        public ImageNode(String url, int w, int h, boolean gif) {
            this.url = url;
            this.w = w;
            this.h = h;
            this.gif = gif;
        }

        @Override
        public String type() {
            return "image";
        }

        @Override
        public class_2487 toNbt() {
            return BookDataModelAdapter.toModel(this).toNbt();
        }

        public static ImageNode fromNbt(class_2487 c) {
            return (ImageNode)BookDataModelAdapter.fromModel(NodeModel.fromNbt(c));
        }
    }

    public static class TextSegment {
        public String text;
        public boolean bold;
        public boolean italic;
        public boolean underline;
        public int argb;
        public float size;
        public int align = 0;

        public TextSegment(String text, boolean bold, boolean italic, boolean underline, int argb, float size) {
            this.text = text;
            this.bold = bold;
            this.italic = italic;
            this.underline = underline;
            this.argb = argb;
            this.size = size;
        }

        public class_2487 toNbt() {
            return BookDataModelAdapter.toModel(this).toNbt();
        }

        public static TextSegment fromNbt(class_2487 c) {
            return BookDataModelAdapter.fromModel(TextSegmentModel.fromNbt(c));
        }

        public TextSegment copy() {
            TextSegment seg = new TextSegment(this.text, this.bold, this.italic, this.underline, this.argb, this.size);
            seg.align = this.align;
            return seg;
        }

        public boolean sameStyle(TextSegment other) {
            if (other == null) {
                return false;
            }
            return this.bold == other.bold && this.italic == other.italic && this.underline == other.underline && this.argb == other.argb && Float.compare(this.size, other.size) == 0 && this.align == other.align;
        }
    }

    public static class TextBoxNode
    extends Node {
        public int x;
        public int y;
        public int width;
        public int height;
        public int bgArgb = 0xFFFFFF;
        public final List<TextSegment> segments = new ArrayList<TextSegment>();

        public TextBoxNode(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        @Override
        public String type() {
            return "textbox";
        }

        @Override
        public class_2487 toNbt() {
            return BookDataModelAdapter.toModel(this).toNbt();
        }

        public static TextBoxNode fromNbt(class_2487 c) {
            return (TextBoxNode)BookDataModelAdapter.fromModel(NodeModel.fromNbt(c));
        }

        public String getFullText() {
            StringBuilder sb = new StringBuilder();
            for (TextSegment seg : this.segments) {
                sb.append(seg.text);
            }
            return sb.toString();
        }

        public void setText(String text, boolean bold, boolean italic, boolean underline, int argb, float size) {
            this.segments.clear();
            if (!text.isEmpty()) {
                this.segments.add(new TextSegment(text, bold, italic, underline, argb, size));
            }
        }
    }

    public static class TextNode
    extends Node {
        public String text;
        public boolean bold;
        public boolean italic;
        public boolean underline;
        public int argb;
        public float size;
        public int align;

        public TextNode(String text, boolean bold, boolean italic, boolean underline, int argb, float size, int align) {
            this.text = text;
            this.bold = bold;
            this.italic = italic;
            this.underline = underline;
            this.argb = argb;
            this.size = size;
            this.align = align;
        }

        @Override
        public String type() {
            return "text";
        }

        @Override
        public class_2487 toNbt() {
            return BookDataModelAdapter.toModel(this).toNbt();
        }

        public static TextNode fromNbt(class_2487 c) {
            return (TextNode)BookDataModelAdapter.fromModel(NodeModel.fromNbt(c));
        }

        public TextNode copy() {
            return new TextNode(this.text, this.bold, this.italic, this.underline, this.argb, this.size, this.align);
        }

        public boolean sameStyle(TextNode other) {
            if (other == null) {
                return false;
            }
            return this.bold == other.bold && this.italic == other.italic && this.underline == other.underline && this.argb == other.argb && Float.compare(this.size, other.size) == 0 && this.align == other.align;
        }
    }

    public static abstract class Node {
        public abstract String type();

        public abstract class_2487 toNbt();

        public static Node fromNbt(class_2487 c) {
            return BookDataModelAdapter.fromModel(NodeModel.fromNbt(c));
        }
    }

    public static class Page {
        public final List<Node> nodes = new ArrayList<Node>();
        public final List<Stroke> strokes = new ArrayList<Stroke>();
        public int bgArgb = -460552;

        public class_2487 toNbt() {
            return BookDataModelAdapter.toModel(this).toNbt();
        }

        public static Page fromNbt(class_2487 c) {
            return BookDataModelAdapter.fromModel(PageModel.fromNbt(c));
        }
    }
}

