/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.data;

import bookeditor.data.BookData;
import bookeditor.data.BookDataUtils;
import bookeditor.data.IBookDataSerializer;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;

public class BookDataSerializerImpl
implements IBookDataSerializer {
    private static final int MAX_TITLE_LEN = 512;
    private static final int MAX_AUTHOR_LEN = 256;
    private static final int MAX_PAGES = 256;
    private static final Logger LOGGER = Logger.getLogger(BookDataSerializerImpl.class.getName());

    @Override
    public void ensureDefaults(class_1799 stack, class_1657 player) {
        class_2487 root = stack.method_7948();
        if (!root.method_10573("CreativeBook", 10)) {
            BookData data = new BookData();
            data.title = class_2561.method_43471((String)"bookeditor.default_title").getString();
            data.authorName = player.method_7334().getName();
            data.authorUuid = player.method_5667();
            data.signed = false;
            BookData.Page p = new BookData.Page();
            p.bgArgb = -460552;
            BookData.TextBoxNode box = new BookData.TextBoxNode(20, 20, 400, 100);
            box.setText(class_2561.method_43471((String)"bookeditor.default_page").getString(), false, false, false, -14671840, 1.0f);
            p.nodes.add(box);
            data.pages.add(p);
            this.writeTo(stack, data);
        }
    }

    @Override
    public BookData readFrom(class_1799 stack) {
        BookData d = new BookData();
        try {
            class_2487 root = stack.method_7948();
            if (!root.method_10573("CreativeBook", 10)) {
                return d;
            }
            class_2487 cb = root.method_10562("CreativeBook");
            d.title = BookDataUtils.safeString(cb.method_10558("title"), 512);
            d.authorName = BookDataUtils.safeString(cb.method_10558("authorName"), 256);
            if (cb.method_10573("authorUuid", 8)) {
                try {
                    d.authorUuid = UUID.fromString(cb.method_10558("authorUuid"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            d.signed = cb.method_10577("signed");
            class_2499 pages = cb.method_10554("pages", 10);
            int pageCount = Math.min(pages.size(), 256);
            for (int i = 0; i < pageCount; ++i) {
                try {
                    d.pages.add(BookData.Page.fromNbt(pages.method_10602(i)));
                    continue;
                }
                catch (RuntimeException ex) {
                    LOGGER.log(Level.WARNING, "BookDataSerializer: skipped page {0} due to error: {1}", new Object[]{i, ex.getMessage()});
                }
            }
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.SEVERE, "BookDataSerializer: failed to read NBT for book item: " + e.getMessage(), e);
            return d;
        }
        return d;
    }

    @Override
    public void writeTo(class_1799 stack, BookData data) {
        class_2487 root = stack.method_7948();
        root.method_10566("CreativeBook", (class_2520)this.toNbt(data));
        stack.method_7980(root);
    }

    @Override
    public class_2487 toNbt(BookData d) {
        class_2487 cb = new class_2487();
        cb.method_10582("title", BookDataUtils.safeString(d.title, 512));
        cb.method_10582("authorName", BookDataUtils.safeString(d.authorName == null ? "" : d.authorName, 256));
        if (d.authorUuid != null) {
            cb.method_10582("authorUuid", d.authorUuid.toString());
        }
        cb.method_10556("signed", d.signed);
        class_2499 pages = new class_2499();
        int added = 0;
        for (BookData.Page p : d.pages) {
            if (added >= 256) break;
            try {
                class_2487 pn = p.toNbt();
                pages.add((Object)pn);
                ++added;
            }
            catch (RuntimeException ex) {
                LOGGER.log(Level.WARNING, "BookDataSerializer: failed to serialize a page, skipping it: {0}", ex.getMessage());
            }
        }
        cb.method_10566("pages", (class_2520)pages);
        return cb;
    }
}

