/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.data.model;

import bookeditor.data.model.NodeModel;
import bookeditor.data.model.StrokeModel;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class PageModel {
    private static final Logger LOGGER = Logger.getLogger(PageModel.class.getName());
    public final List<NodeModel> nodes = new ArrayList<NodeModel>();
    public final List<StrokeModel> strokes = new ArrayList<StrokeModel>();
    public int bgArgb = -460552;

    public class_2487 toNbt() {
        class_2487 c = new class_2487();
        class_2499 list = new class_2499();
        int addedNodes = 0;
        for (NodeModel n : this.nodes) {
            if (addedNodes >= 512) break;
            try {
                list.add((Object)n.toNbt());
            }
            catch (RuntimeException ex) {
                LOGGER.log(Level.WARNING, "PageModel: failed to serialize node, skipping: {0}", ex.getMessage());
            }
            ++addedNodes;
        }
        c.method_10566("nodes", (class_2520)list);
        class_2499 strokesNbt = new class_2499();
        int addedStrokes = 0;
        for (StrokeModel s : this.strokes) {
            if (addedStrokes >= 1024) break;
            try {
                strokesNbt.add((Object)s.toNbt());
            }
            catch (RuntimeException ex) {
                LOGGER.log(Level.WARNING, "PageModel: failed to serialize stroke, skipping: {0}", ex.getMessage());
            }
            ++addedStrokes;
        }
        c.method_10566("strokes", (class_2520)strokesNbt);
        c.method_10569("bg", this.bgArgb);
        return c;
    }

    public static PageModel fromNbt(class_2487 c) {
        PageModel p = new PageModel();
        class_2499 list = c.method_10554("nodes", 10);
        int nodeLimit = Math.min(list.size(), 512);
        for (int i = 0; i < nodeLimit; ++i) {
            try {
                p.nodes.add(NodeModel.fromNbt(list.method_10602(i)));
                continue;
            }
            catch (RuntimeException ex) {
                LOGGER.log(Level.WARNING, "PageModel: skipped node {0} due to error: {1}", new Object[]{i, ex.getMessage()});
            }
        }
        if (c.method_10573("strokes", 9)) {
            class_2499 sList = c.method_10554("strokes", 10);
            int strokeLimit = Math.min(sList.size(), 1024);
            for (int i = 0; i < strokeLimit; ++i) {
                try {
                    p.strokes.add(StrokeModel.fromNbt(sList.method_10602(i)));
                    continue;
                }
                catch (RuntimeException ex) {
                    LOGGER.log(Level.WARNING, "PageModel: skipped stroke {0} due to error: {1}", new Object[]{i, ex.getMessage()});
                }
            }
        }
        if (c.method_10573("bg", 3)) {
            p.bgArgb = c.method_10550("bg");
        }
        return p;
    }
}

