/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.data.model;

import bookeditor.data.model.NodeModel;
import bookeditor.data.model.TextSegmentModel;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class TextBoxNodeModel
extends NodeModel {
    private static final Logger LOGGER = Logger.getLogger(TextBoxNodeModel.class.getName());
    public int x;
    public int y;
    public int width;
    public int height;
    public int bgArgb = 0xFFFFFF;
    public final List<TextSegmentModel> segments = new ArrayList<TextSegmentModel>();

    public TextBoxNodeModel(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    @Override
    public String type() {
        return "textbox";
    }

    @Override
    public class_2487 toNbt() {
        class_2487 c = new class_2487();
        c.method_10582("type", "textbox");
        c.method_10569("x", this.x);
        c.method_10569("y", this.y);
        c.method_10569("w", this.width);
        c.method_10569("h", this.height);
        c.method_10569("bgArgb", this.bgArgb);
        class_2499 segList = new class_2499();
        int added = 0;
        for (TextSegmentModel seg : this.segments) {
            if (added >= 1024) break;
            try {
                segList.add((Object)seg.toNbt());
            }
            catch (RuntimeException ex) {
                LOGGER.log(Level.WARNING, "TextBoxNodeModel: failed to serialize segment, skipping: {0}", ex.getMessage());
            }
            ++added;
        }
        c.method_10566("segments", (class_2520)segList);
        return c;
    }

    public static TextBoxNodeModel fromNbt(class_2487 c) {
        TextBoxNodeModel box = new TextBoxNodeModel(c.method_10550("x"), c.method_10550("y"), c.method_10550("w"), c.method_10550("h"));
        int n = box.bgArgb = c.method_10573("bgArgb", 3) ? c.method_10550("bgArgb") : 0xFFFFFF;
        if (c.method_10573("segments", 9)) {
            class_2499 segList = c.method_10554("segments", 10);
            int limit = Math.min(segList.size(), 1024);
            for (int i = 0; i < limit; ++i) {
                try {
                    box.segments.add(TextSegmentModel.fromNbt(segList.method_10602(i)));
                    continue;
                }
                catch (RuntimeException ex) {
                    LOGGER.log(Level.WARNING, "TextBoxNodeModel: skipped segment {0} due to error: {1}", new Object[]{i, ex.getMessage()});
                }
            }
        }
        return box;
    }
}

