/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrcomputer1.smileyplayertrader.command;

import io.github.mrcomputer1.smileyplayertrader.SPTConfiguration;
import io.github.mrcomputer1.smileyplayertrader.SmileyPlayerTrader;
import io.github.mrcomputer1.smileyplayertrader.command.ICommand;
import io.github.mrcomputer1.smileyplayertrader.util.I18N;
import io.github.mrcomputer1.smileyplayertrader.util.database.statements.StatementHandler;
import io.github.mrcomputer1.smileyplayertrader.util.item.ItemUtil;
import io.github.mrcomputer1.smileyplayertrader.versions.VersionSupport;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CreateCommand
implements ICommand {
    private void sendUsage(CommandSender sender) {
        sender.sendMessage(I18N.translate("&cBad Syntax! &f/spt create [product [amount]] (amount <amount>|cost1 <cost> [amount]|cost2 <cost> [amount]|hidden|disabled|discount <amount>|priority <priority>|purchaselimit <limit>|hideonoutofstock|deposithand|unlimitedsupply|player <player>)...", new Object[0]));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onCommand(CommandSender sender, String[] rawArgs) {
        ItemStack product;
        boolean hideOnOutOfStock;
        if (rawArgs.length < 1) {
            this.sendUsage(sender);
            return;
        }
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(rawArgs));
        OfflinePlayer player = sender instanceof OfflinePlayer ? (OfflinePlayer)sender : null;
        Player sendingPlayer = sender instanceof Player ? (Player)sender : null;
        ItemStack cost1 = null;
        ItemStack cost2 = null;
        boolean hidden = false;
        boolean disabled = false;
        int specialPrice = 0;
        int priority = 0;
        int purchaseLimit = -1;
        boolean unlimitedSupply = false;
        boolean depositHand = false;
        SPTConfiguration.EnumOutOfStockBehaviour outOfStockBehaviour = SmileyPlayerTrader.getInstance().getConfiguration().getOutOfStockBehaviour();
        switch (outOfStockBehaviour) {
            case HIDE_BY_DEFAULT: 
            case HIDE: {
                hideOnOutOfStock = true;
                break;
            }
            default: {
                hideOnOutOfStock = false;
            }
        }
        Material material = Material.matchMaterial((String)((String)args.get(0)));
        if (material == null) {
            if (sendingPlayer == null) {
                sender.sendMessage(I18N.translate("&cYou must be running this command from a player.", new Object[0]));
                return;
            }
            ItemStack hand = sendingPlayer.getInventory().getItemInMainHand();
            if (hand.getType().isAir()) {
                if (!SmileyPlayerTrader.getInstance().getConfiguration().getRequireItemInHandWhileUsingCreateCommand()) {
                    sender.sendMessage(I18N.translate("&cYou must be holding an item in your main hand or specify a valid item!", new Object[0]));
                    return;
                }
                sender.sendMessage(I18N.translate("&cYou must be holding an item in your main hand!", new Object[0]));
                return;
            }
            product = sendingPlayer.getInventory().getItemInMainHand().clone();
        } else {
            if (!material.isItem() || material.isAir()) {
                sender.sendMessage(I18N.translate("&c%0% isn't a valid item.", args.get(0)));
                return;
            }
            product = new ItemStack(material);
            if (SmileyPlayerTrader.getInstance().getConfiguration().getRequireItemInHandWhileUsingCreateCommand() && sendingPlayer != null && !product.isSimilar(sendingPlayer.getInventory().getItemInMainHand())) {
                sender.sendMessage(I18N.translate("&cYou must be holding a matching item in your main hand!", new Object[0]));
                return;
            }
            args.remove(0);
        }
        if (!args.isEmpty()) {
            try {
                int count = Integer.parseInt((String)args.get(0));
                if (count < 1 || count > product.getMaxStackSize()) {
                    sender.sendMessage(I18N.translate("&cNumber is either too large or too small.", new Object[0]));
                    return;
                }
                args.remove(0);
            }
            catch (NumberFormatException count) {
                // empty catch block
            }
        }
        block50: while (!args.isEmpty()) {
            String command;
            switch (command = ((String)args.remove(0)).toLowerCase()) {
                case "amount": {
                    if (args.isEmpty()) {
                        this.sendUsage(sender);
                        return;
                    }
                    try {
                        int count = Integer.parseInt((String)args.remove(0));
                        if (count < 1 || count > product.getMaxStackSize()) {
                            sender.sendMessage(I18N.translate("&cNumber is either too large or too small.", new Object[0]));
                            return;
                        }
                        product.setAmount(count);
                        continue block50;
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(I18N.translate("&cInvalid Number!", new Object[0]));
                        return;
                    }
                }
                case "cost1": 
                case "primarycost": 
                case "cost": {
                    if (args.isEmpty()) {
                        this.sendUsage(sender);
                        return;
                    }
                    Material material2 = Material.matchMaterial((String)((String)args.remove(0)));
                    if (material2 == null || !material2.isItem() || material2.isAir()) {
                        sender.sendMessage(I18N.translate("&c%0% isn't a valid item.", args.get(0)));
                        return;
                    }
                    cost1 = new ItemStack(material2);
                    if (args.isEmpty()) continue block50;
                    try {
                        int count = Integer.parseInt((String)args.get(0));
                        if (count < 1 || count > material2.getMaxStackSize()) {
                            sender.sendMessage(I18N.translate("&cNumber is either too large or too small.", new Object[0]));
                            return;
                        }
                        cost1.setAmount(count);
                        args.remove(0);
                    }
                    catch (NumberFormatException count) {}
                    continue block50;
                }
                case "cost2": 
                case "secondarycost": {
                    if (args.isEmpty()) {
                        this.sendUsage(sender);
                        return;
                    }
                    Material material3 = Material.matchMaterial((String)((String)args.remove(0)));
                    if (material3 == null || !material3.isItem() || material3.isAir()) {
                        sender.sendMessage(I18N.translate("&c%0% isn't a valid item.", args.get(0)));
                        return;
                    }
                    cost2 = new ItemStack(material3);
                    if (args.isEmpty()) continue block50;
                    try {
                        int count = Integer.parseInt((String)args.get(0));
                        if (count < 1 || count > material3.getMaxStackSize()) {
                            sender.sendMessage(I18N.translate("&cNumber is either too large or too small.", new Object[0]));
                            return;
                        }
                        cost2.setAmount(count);
                        args.remove(0);
                    }
                    catch (NumberFormatException count) {}
                    continue block50;
                }
                case "hidden": {
                    hidden = true;
                    continue block50;
                }
                case "disabled": {
                    disabled = true;
                    continue block50;
                }
                case "discount": {
                    if (args.isEmpty()) {
                        this.sendUsage(sender);
                        return;
                    }
                    if (cost1 == null) {
                        sender.sendMessage(I18N.translate("&cYou must specify primary cost first.", new Object[0]));
                        return;
                    }
                    try {
                        int discount = Integer.parseInt((String)args.remove(0));
                        int calculatedPrice = -discount + cost1.getAmount();
                        if (calculatedPrice < 1 || calculatedPrice > cost1.getMaxStackSize()) {
                            sender.sendMessage(I18N.translate("&cDiscount would make price too small or too large.", new Object[0]));
                            return;
                        }
                        specialPrice = discount;
                        continue block50;
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(I18N.translate("&cInvalid Number!", new Object[0]));
                        return;
                    }
                }
                case "priority": {
                    if (args.isEmpty()) {
                        this.sendUsage(sender);
                        return;
                    }
                    try {
                        priority = Integer.parseInt((String)args.remove(0));
                        continue block50;
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(I18N.translate("&cInvalid Number!", new Object[0]));
                        return;
                    }
                }
                case "purchaselimit": {
                    if (args.isEmpty()) {
                        this.sendUsage(sender);
                        return;
                    }
                    try {
                        purchaseLimit = Integer.parseInt((String)args.remove(0));
                        continue block50;
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(I18N.translate("&cInvalid Number!", new Object[0]));
                        return;
                    }
                }
                case "hideonoutofstock": {
                    hideOnOutOfStock = true;
                    continue block50;
                }
                case "deposithand": {
                    if (!SmileyPlayerTrader.getInstance().getConfiguration().getItemStorageEnabled()) {
                        sender.sendMessage(I18N.translate("&cItem storage is not enabled.", new Object[0]));
                        return;
                    }
                    depositHand = true;
                    continue block50;
                }
                case "unlimitedsupply": {
                    if (!sender.hasPermission("smileyplayertrader.unlimitedsupply")) {
                        sender.sendMessage(I18N.translate("&cWhoops! You are not authorised to do that.", new Object[0]));
                        return;
                    }
                    unlimitedSupply = true;
                    continue block50;
                }
                case "player": {
                    if (args.isEmpty()) {
                        this.sendUsage(sender);
                        return;
                    }
                    if (!sender.hasPermission("smileyplayertrader.others")) {
                        sender.sendMessage(I18N.translate("&cWhoops! You are not authorized to edit others products!", new Object[0]));
                        return;
                    }
                    player = Bukkit.getOfflinePlayer((String)((String)args.remove(0)));
                    continue block50;
                }
            }
            sender.sendMessage(I18N.translate("&cInvalid option %0%.", command));
            return;
        }
        if (player == null) {
            sender.sendMessage(I18N.translate("&cYou must be running this command from a player.", new Object[0]));
            return;
        }
        try {
            byte[] stackBytes = VersionSupport.itemStackToByteArray(product);
            byte[] cost1Bytes = cost1 == null ? null : VersionSupport.itemStackToByteArray(cost1);
            byte[] cost2Bytes = cost2 == null ? null : VersionSupport.itemStackToByteArray(cost2);
            long id = SmileyPlayerTrader.getInstance().getStatementHandler().runAndReturnInsertId(StatementHandler.StatementType.ADD_PRODUCT, player.getUniqueId().toString(), stackBytes, cost1Bytes, cost2Bytes, !disabled, !hidden, specialPrice, priority, hideOnOutOfStock);
            if (unlimitedSupply) {
                SmileyPlayerTrader.getInstance().getStatementHandler().run(StatementHandler.StatementType.TOGGLE_UNLIMITED_SUPPLY, id);
            }
            SmileyPlayerTrader.getInstance().getStatementHandler().run(StatementHandler.StatementType.SET_PURCHASE_LIMIT, id, purchaseLimit);
            if (depositHand && sendingPlayer != null) {
                ItemStack hand = sendingPlayer.getInventory().getItemInMainHand();
                if (hand.isSimilar(product)) {
                    int count = hand.getAmount();
                    int limit = SmileyPlayerTrader.getInstance().getConfiguration().getItemStorageProductStorageLimit();
                    if (limit != -1 && count > limit) {
                        sender.sendMessage(I18N.translate("&cYou cannot store more than %0% of a product.", limit));
                        return;
                    }
                    SmileyPlayerTrader.getInstance().getStatementHandler().run(StatementHandler.StatementType.CHANGE_STORED_PRODUCT, count, id);
                    hand.setAmount(hand.getAmount() - count);
                } else {
                    sender.sendMessage(I18N.translate("&cThis item does not match the type of the product so no items were deposited.", new Object[0]));
                }
            }
            sender.spigot().sendMessage(I18N.translateComponents("&aCreated product %0% with ID %1%.", new BaseComponent[]{ItemUtil.getItemTextComponent(product), new TextComponent(String.valueOf(id))}));
            return;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isVisibleInTabComplete(CommandSender sender) {
        return true;
    }
}

