/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrcomputer1.smileyplayertrader.command;

import io.github.mrcomputer1.smileyplayertrader.SmileyPlayerTrader;
import io.github.mrcomputer1.smileyplayertrader.command.ICommand;
import io.github.mrcomputer1.smileyplayertrader.util.CommandUtil;
import io.github.mrcomputer1.smileyplayertrader.util.I18N;
import io.github.mrcomputer1.smileyplayertrader.util.database.statements.StatementHandler;
import io.github.mrcomputer1.smileyplayertrader.util.item.ItemUtil;
import io.github.mrcomputer1.smileyplayertrader.versions.VersionSupport;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class WithdrawCommand
implements ICommand {
    @Override
    public void onCommand(CommandSender sender, String[] args) {
        block21: {
            long id;
            if (!(sender instanceof Player)) {
                sender.sendMessage(I18N.translate("&cYou must be running this command from a player.", new Object[0]));
                return;
            }
            if (!SmileyPlayerTrader.getInstance().getConfiguration().getItemStorageEnabled()) {
                sender.sendMessage(I18N.translate("&cItem storage is not enabled.", new Object[0]));
                return;
            }
            if (args.length < 1) {
                sender.sendMessage(I18N.translate("&cBad Syntax! &f/spt withdraw <id> [limit]", new Object[0]));
                return;
            }
            try {
                id = Long.parseLong(args[0]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(I18N.translate("&cInvalid Number!", new Object[0]));
                return;
            }
            if (CommandUtil.isNotAuthorized(sender, id)) {
                sender.sendMessage(I18N.translate("&cWhoops! You are not authorized to edit others products!", new Object[0]));
                return;
            }
            Player p = (Player)sender;
            try (ResultSet set = SmileyPlayerTrader.getInstance().getStatementHandler().get(StatementHandler.StatementType.GET_PRODUCT_BY_ID, id);){
                int countAvailable;
                if (!set.next()) break block21;
                int limit = Integer.MAX_VALUE;
                if (args.length >= 2) {
                    try {
                        limit = Integer.parseInt(args[1]);
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(I18N.translate("&cInvalid Number!", new Object[0]));
                    }
                }
                if (limit > (countAvailable = set.getInt("stored_product"))) {
                    limit = countAvailable;
                }
                if (limit <= 0) {
                    sender.sendMessage(I18N.translate("&cYou do not have enough of that product.", new Object[0]));
                    return;
                }
                ItemStack stack = VersionSupport.byteArrayToItemStack(set.getBytes("product"));
                stack.setAmount(limit);
                HashMap errs = p.getInventory().addItem(new ItemStack[]{stack});
                for (ItemStack is : errs.values()) {
                    p.getWorld().dropItem(p.getLocation(), is);
                }
                SmileyPlayerTrader.getInstance().getStatementHandler().run(StatementHandler.StatementType.CHANGE_STORED_PRODUCT, -limit, id);
                sender.spigot().sendMessage(I18N.translateComponents("&aWithdrew %0% of %1%.", new BaseComponent[]{new TextComponent(String.valueOf(limit)), ItemUtil.getItemTextComponent(stack)}));
            }
            catch (InvocationTargetException | SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public boolean isVisibleInTabComplete(CommandSender sender) {
        return sender instanceof Player;
    }
}

