/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrcomputer1.smileyplayertrader;

import io.github.mrcomputer1.smileyplayertrader.PlayerConfig;
import io.github.mrcomputer1.smileyplayertrader.SPTConfiguration;
import io.github.mrcomputer1.smileyplayertrader.SmileyPlayerTrader;
import io.github.mrcomputer1.smileyplayertrader.gui.framework.GUIManager;
import io.github.mrcomputer1.smileyplayertrader.util.GeyserUtil;
import io.github.mrcomputer1.smileyplayertrader.util.I18N;
import io.github.mrcomputer1.smileyplayertrader.util.database.statements.StatementHandler;
import io.github.mrcomputer1.smileyplayertrader.util.item.ItemUtil;
import io.github.mrcomputer1.smileyplayertrader.util.item.stocklocations.StockLocations;
import io.github.mrcomputer1.smileyplayertrader.util.merchant.MerchantUtil;
import io.github.mrcomputer1.smileyplayertrader.versions.VersionSupport;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantInventory;
import org.bukkit.plugin.Plugin;

public class TradeEventListener
implements Listener {
    private static final int INPUT_SLOT_1 = 0;
    private static final int INPUT_SLOT_2 = 1;
    private static final int TRADE_SLOT = 2;

    @EventHandler
    public void onEntityRightClick(PlayerInteractAtEntityEvent e) {
        if (e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (SmileyPlayerTrader.getInstance().getConfiguration().getDisableRightClickTrading()) {
            return;
        }
        if (e.getRightClicked().hasMetadata("NPC")) {
            return;
        }
        if (!e.getPlayer().hasPermission("smileyplayertrader.trade")) {
            return;
        }
        PlayerConfig.Config playerConfig = SmileyPlayerTrader.getInstance().getPlayerConfig().getPlayer(e.getPlayer());
        if (playerConfig == null) {
            return;
        }
        if (!playerConfig.tradeToggle || SmileyPlayerTrader.getInstance().getPlayerConfig().isLocked(e.getPlayer())) {
            return;
        }
        if (e.getRightClicked().getType() == EntityType.PLAYER) {
            Player store = (Player)e.getRightClicked();
            MerchantUtil.openMerchant(e.getPlayer(), (OfflinePlayer)store, false, false);
        }
    }

    private boolean verifyTradeStillValid(InventoryClickEvent e, MerchantInventory mi, ResultSet set) throws SQLException, InvocationTargetException {
        int discount;
        if (!set.getBoolean("enabled") || !set.getBoolean("available")) {
            e.setCancelled(true);
            GUIManager.sendErrorMessage(e.getWhoClicked(), I18N.translate("&cThis product is no longer for sale.", new Object[0]));
            return false;
        }
        byte[] productBytes = set.getBytes("product");
        if (productBytes == null) {
            e.setCancelled(true);
            GUIManager.sendErrorMessage(e.getWhoClicked(), I18N.translate("&cThis product has been changed, please reopen the trading UI.", new Object[0]));
            return false;
        }
        ItemStack product = VersionSupport.byteArrayToItemStack(productBytes);
        if (product == null || !product.equals((Object)mi.getSelectedRecipe().getResult())) {
            e.setCancelled(true);
            GUIManager.sendErrorMessage(e.getWhoClicked(), I18N.translate("&cThis product has been changed, please reopen the trading UI.", new Object[0]));
            return false;
        }
        byte[] cost1Bytes = set.getBytes("cost1");
        if (cost1Bytes == null) {
            e.setCancelled(true);
            GUIManager.sendErrorMessage(e.getWhoClicked(), I18N.translate("&cThis product has been changed, please reopen the trading UI.", new Object[0]));
            return false;
        }
        ItemStack cost1 = VersionSupport.byteArrayToItemStack(cost1Bytes);
        ItemStack cost1InSlot = (ItemStack)mi.getSelectedRecipe().getIngredients().get(0);
        if (cost1 == null || !cost1.equals((Object)cost1InSlot)) {
            e.setCancelled(true);
            GUIManager.sendErrorMessage(e.getWhoClicked(), I18N.translate("&cThis product has been changed, please reopen the trading UI.", new Object[0]));
            return false;
        }
        byte[] cost2Bytes = set.getBytes("cost2");
        if (cost2Bytes == null && mi.getSelectedRecipe().getIngredients().size() >= 2) {
            e.setCancelled(true);
            GUIManager.sendErrorMessage(e.getWhoClicked(), I18N.translate("&cThis product has been changed, please reopen the trading UI.", new Object[0]));
            return false;
        }
        if (cost2Bytes != null) {
            ItemStack cost2InSlot;
            ItemStack cost2 = VersionSupport.byteArrayToItemStack(cost2Bytes);
            ItemStack itemStack = cost2InSlot = mi.getSelectedRecipe().getIngredients().size() >= 2 ? (ItemStack)mi.getSelectedRecipe().getIngredients().get(1) : null;
            if (cost2 == null || !cost2.equals((Object)cost2InSlot)) {
                e.setCancelled(true);
                GUIManager.sendErrorMessage(e.getWhoClicked(), I18N.translate("&cThis product has been changed, please reopen the trading UI.", new Object[0]));
                return false;
            }
        }
        if ((discount = -set.getInt("special_price")) != VersionSupport.getSpecialCountForRecipe(mi)) {
            e.setCancelled(true);
            GUIManager.sendErrorMessage(e.getWhoClicked(), I18N.translate("&cThis product has been changed, please reopen the trading UI.", new Object[0]));
            return false;
        }
        int purchaseLimit = set.getInt("purchase_limit");
        int purchaseCount = set.getInt("purchase_count");
        if (purchaseLimit != -1 && purchaseCount >= purchaseLimit) {
            e.setCancelled(true);
            GUIManager.sendErrorMessage(e.getWhoClicked(), I18N.translate("&cThis product is no longer for sale.", new Object[0]));
            return false;
        }
        return true;
    }

    private void handleItemRanOutOfStockAfterPurchase(InventoryClickEvent e, MerchantInventory mi, OfflinePlayer store, long productId, boolean unlimitedSupply) throws InvocationTargetException {
        if (!unlimitedSupply && !ItemUtil.doesPlayerHaveItem(store, mi.getSelectedRecipe().getResult(), productId)) {
            if (store.isOnline()) {
                store.getPlayer().spigot().sendMessage(I18N.translateComponents("&c%0% is now out of stock!", ItemUtil.getItemTextComponent(mi.getSelectedRecipe().getResult())));
            }
            e.setCancelled(true);
            ItemStack cost1 = e.getInventory().getItem(0);
            ItemStack cost2 = e.getInventory().getItem(1);
            if (cost1 == null) {
                cost1 = cost2;
                cost2 = null;
            }
            cost1.setAmount(cost1.getAmount() - ItemUtil.computeAdjustedPrice(mi.getSelectedRecipe(), VersionSupport.getSpecialCountForRecipe(mi)));
            if (mi.getSelectedRecipe().getIngredients().size() >= 2) {
                cost2.setAmount(cost2.getAmount() - ((ItemStack)mi.getSelectedRecipe().getIngredients().get(1)).getAmount());
            }
            Runnable reopenMerchant = () -> {
                MerchantUtil.openMerchant((Player)e.getWhoClicked(), store, true, true);
                InventoryView iv = e.getWhoClicked().getOpenInventory();
                iv.setCursor(mi.getSelectedRecipe().getResult());
            };
            if (GeyserUtil.isBedrockPlayer((Player)e.getWhoClicked())) {
                e.getWhoClicked().closeInventory();
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SmileyPlayerTrader.getInstance(), reopenMerchant, 20L);
            } else {
                reopenMerchant.run();
            }
        }
    }

    private void processItemPurchase(InventoryClickEvent e, MerchantInventory mi, OfflinePlayer store, long productId, boolean unlimitedSupply) {
        assert (mi.getSelectedRecipe() != null);
        if (!unlimitedSupply) {
            ItemUtil.removeStock(store, mi.getSelectedRecipe().getResult(), productId);
        }
        try {
            if (!unlimitedSupply || SmileyPlayerTrader.getInstance().getConfiguration().getDoesUnlimitedSupplyEarn()) {
                ItemUtil.giveEarnings(store, mi.getSelectedRecipe(), VersionSupport.getSpecialCountForRecipe(mi), productId);
            }
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
            SmileyPlayerTrader.getInstance().getLogger().severe("Something went wrong while attempting to give earnings to " + store.getName());
        }
        MerchantUtil.thankPurchaser(store, (Player)e.getWhoClicked());
        SmileyPlayerTrader.getInstance().getStatementHandler().run(StatementHandler.StatementType.INCREMENT_PURCHASE_COUNT, productId);
        if (store.isOnline()) {
            store.getPlayer().sendMessage(I18N.translate("&a%0% just purchased %1%!", e.getWhoClicked().getName(), mi.getSelectedRecipe().getResult().getType()));
        }
        try {
            this.handleItemRanOutOfStockAfterPurchase(e, mi, store, productId, unlimitedSupply);
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
    }

    private boolean ensureCostMatchs(InventoryClickEvent e, MerchantInventory mi) {
        ItemStack cost1 = e.getInventory().getItem(0);
        ItemStack cost2 = e.getInventory().getItem(1);
        if (cost1 == null) {
            cost1 = cost2;
            cost2 = null;
        }
        if (!cost1.isSimilar((ItemStack)mi.getSelectedRecipe().getIngredients().get(0))) {
            e.setCancelled(true);
            GUIManager.sendErrorMessage(e.getWhoClicked(), I18N.translate("&cThe item you are using to pay doesn't match the cost.", new Object[0]));
            return false;
        }
        if (mi.getSelectedRecipe().getIngredients().size() >= 2 && !cost2.isSimilar((ItemStack)mi.getSelectedRecipe().getIngredients().get(1))) {
            e.setCancelled(true);
            GUIManager.sendErrorMessage(e.getWhoClicked(), I18N.translate("&cThe item you are using to pay doesn't match the cost.", new Object[0]));
            return false;
        }
        return true;
    }

    private void onTradeSlotClick(InventoryClickEvent e) {
        boolean unlimitedSupply;
        long productId;
        OfflinePlayer store;
        MerchantInventory mi;
        block17: {
            if (e.getClick() == ClickType.SHIFT_LEFT || e.getClick() == ClickType.SHIFT_RIGHT) {
                e.setCancelled(true);
                return;
            }
            mi = (MerchantInventory)e.getInventory();
            store = Bukkit.getOfflinePlayer((String)e.getView().getTitle().replace(I18N.translate("&2Villager Store: ", new Object[0]), ""));
            if (!store.isOnline() && !StockLocations.canTradeWithPlayer(store)) {
                e.setCancelled(true);
                GUIManager.sendErrorMessage(e.getWhoClicked(), I18N.translate("&cYou cannot trade with offline players.", new Object[0]));
                return;
            }
            if (mi.getSelectedRecipe() == null) {
                return;
            }
            productId = MerchantUtil.getProductId((Player)e.getWhoClicked(), VersionSupport.getMerchantRecipeOriginalResult(mi.getSelectedRecipe()));
            try (ResultSet set = SmileyPlayerTrader.getInstance().getStatementHandler().get(StatementHandler.StatementType.GET_PRODUCT_BY_ID, productId);){
                if (set.next()) {
                    if (!this.verifyTradeStillValid(e, mi, set)) {
                        return;
                    }
                    unlimitedSupply = set.getBoolean("unlimited_supply");
                    break block17;
                }
                e.setCancelled(true);
                GUIManager.sendErrorMessage(e.getWhoClicked(), I18N.translate("&cThis product is no longer for sale.", new Object[0]));
                return;
            }
            catch (InvocationTargetException | SQLException ex) {
                ex.printStackTrace();
                e.setCancelled(true);
                return;
            }
        }
        if (SmileyPlayerTrader.getInstance().getConfiguration().getPurchaseCostComparison() == SPTConfiguration.EnumPurchaseCostComparison.STRICT && !this.ensureCostMatchs(e, mi)) {
            return;
        }
        if (unlimitedSupply || ItemUtil.doesPlayerHaveItem(store, mi.getSelectedRecipe().getResult(), productId)) {
            this.processItemPurchase(e, mi, store, productId, unlimitedSupply);
        } else {
            e.setCancelled(true);
            GUIManager.sendErrorMessage(e.getWhoClicked(), I18N.translate("&cThis item is out of stock!", new Object[0]));
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (e.getView().getType() == InventoryType.MERCHANT) {
            if (e.getView().getTitle().startsWith(I18N.translate("&2Villager Store: ", new Object[0]))) {
                if (e.getRawSlot() == 2) {
                    this.onTradeSlotClick(e);
                }
            } else if (e.getView().getTitle().startsWith(I18N.translate("&2Preview Store: ", new Object[0])) && e.getRawSlot() == 2) {
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent e) {
        if (e.getView().getType() == InventoryType.MERCHANT) {
            MerchantUtil.clearProductIdCache((Player)e.getPlayer());
        }
    }
}

