/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrcomputer1.smileyplayertrader.command;

import io.github.mrcomputer1.smileyplayertrader.SmileyPlayerTrader;
import io.github.mrcomputer1.smileyplayertrader.command.ICommand;
import io.github.mrcomputer1.smileyplayertrader.util.CommandUtil;
import io.github.mrcomputer1.smileyplayertrader.util.I18N;
import io.github.mrcomputer1.smileyplayertrader.util.database.statements.StatementHandler;
import io.github.mrcomputer1.smileyplayertrader.util.item.ItemUtil;
import io.github.mrcomputer1.smileyplayertrader.versions.VersionSupport;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class DepositCommand
implements ICommand {
    @Override
    public void onCommand(CommandSender sender, String[] args) {
        long id;
        if (!(sender instanceof Player)) {
            sender.sendMessage(I18N.translate("&cYou must be running this command from a player.", new Object[0]));
            return;
        }
        if (!SmileyPlayerTrader.getInstance().getConfiguration().getItemStorageEnabled()) {
            sender.sendMessage(I18N.translate("&cItem storage is not enabled.", new Object[0]));
            return;
        }
        if (args.length < 1) {
            sender.sendMessage(I18N.translate("&cBad Syntax! &f/spt deposit <id>", new Object[0]));
            return;
        }
        try {
            id = Long.parseLong(args[0]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(I18N.translate("&cInvalid Number!", new Object[0]));
            return;
        }
        if (CommandUtil.isNotAuthorized(sender, id)) {
            sender.sendMessage(I18N.translate("&cWhoops! You are not authorized to edit others products!", new Object[0]));
            return;
        }
        Player p = (Player)sender;
        if (p.getInventory().getItemInMainHand().getType().isAir()) {
            sender.sendMessage(I18N.translate("&cYou must be holding an item in your main hand!", new Object[0]));
            return;
        }
        ItemStack hand = p.getInventory().getItemInMainHand();
        try (ResultSet set = SmileyPlayerTrader.getInstance().getStatementHandler().get(StatementHandler.StatementType.GET_PRODUCT_BY_ID, id);){
            if (set.next()) {
                byte[] productBytes = set.getBytes("product");
                if (productBytes == null) {
                    sender.sendMessage(I18N.translate("&cThis item does not match the type of the product.", new Object[0]));
                    return;
                }
                ItemStack product = VersionSupport.byteArrayToItemStack(productBytes);
                if (hand.isSimilar(product)) {
                    int count = hand.getAmount();
                    int limit = SmileyPlayerTrader.getInstance().getConfiguration().getItemStorageProductStorageLimit();
                    if (limit != -1 && set.getInt("stored_product") + count > limit) {
                        sender.sendMessage(I18N.translate("&cYou cannot store more than %0% of a product.", limit));
                        return;
                    }
                    SmileyPlayerTrader.getInstance().getStatementHandler().run(StatementHandler.StatementType.CHANGE_STORED_PRODUCT, count, id);
                    hand.setAmount(hand.getAmount() - count);
                    sender.spigot().sendMessage(I18N.translateComponents("&aDeposited %0% of %1%.", new BaseComponent[]{new TextComponent(String.valueOf(count)), ItemUtil.getItemTextComponent(product)}));
                } else {
                    sender.sendMessage(I18N.translate("&cThis item does not match the type of the product.", new Object[0]));
                }
            }
        }
        catch (InvocationTargetException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isVisibleInTabComplete(CommandSender sender) {
        return sender instanceof Player && SmileyPlayerTrader.getInstance().getConfiguration().getItemStorageEnabled();
    }
}

