/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrcomputer1.smileyplayertrader.command;

import io.github.mrcomputer1.smileyplayertrader.SmileyPlayerTrader;
import io.github.mrcomputer1.smileyplayertrader.command.ICommand;
import io.github.mrcomputer1.smileyplayertrader.util.CommandUtil;
import io.github.mrcomputer1.smileyplayertrader.util.I18N;
import io.github.mrcomputer1.smileyplayertrader.util.database.statements.StatementHandler;
import io.github.mrcomputer1.smileyplayertrader.versions.VersionSupport;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;

public class DiscountCommand
implements ICommand {
    @Override
    public void onCommand(CommandSender sender, String[] args) {
        int amount;
        long id;
        if (args.length < 1) {
            sender.sendMessage(I18N.translate("&cBad Syntax! &f/spt discount <id> [amount]", new Object[0]));
            return;
        }
        try {
            id = Long.parseLong(args[0]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(I18N.translate("&cInvalid Number!", new Object[0]));
            return;
        }
        if (args.length < 2) {
            amount = 0;
        } else {
            try {
                amount = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(I18N.translate("&cInvalid Number!", new Object[0]));
                return;
            }
        }
        if (CommandUtil.isNotAuthorized(sender, id)) {
            sender.sendMessage(I18N.translate("&cWhoops! You are not authorized to edit others products!", new Object[0]));
            return;
        }
        try (ResultSet set = SmileyPlayerTrader.getInstance().getStatementHandler().get(StatementHandler.StatementType.GET_PRODUCT_BY_ID, id);){
            if (set.next()) {
                byte[] cost = set.getBytes("cost1");
                ItemStack costIS = VersionSupport.byteArrayToItemStack(cost);
                int specialPrice = -amount + costIS.getAmount();
                if (specialPrice < 1 || specialPrice > costIS.getMaxStackSize()) {
                    sender.sendMessage(I18N.translate("&cDiscount would make price too small or too large.", new Object[0]));
                } else {
                    SmileyPlayerTrader.getInstance().getStatementHandler().run(StatementHandler.StatementType.SET_DISCOUNT, amount, id);
                    sender.sendMessage(I18N.translate("&aSet discount.", new Object[0]));
                }
            }
        }
        catch (InvocationTargetException | SQLException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean isVisibleInTabComplete(CommandSender sender) {
        return true;
    }
}

