/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrcomputer1.smileyplayertrader.command;

import io.github.mrcomputer1.smileyplayertrader.SmileyPlayerTrader;
import io.github.mrcomputer1.smileyplayertrader.command.ICommand;
import io.github.mrcomputer1.smileyplayertrader.util.CommandUtil;
import io.github.mrcomputer1.smileyplayertrader.util.I18N;
import io.github.mrcomputer1.smileyplayertrader.util.TradeNotification;
import io.github.mrcomputer1.smileyplayertrader.util.database.statements.StatementHandler;
import io.github.mrcomputer1.smileyplayertrader.versions.VersionSupport;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SetProductCommand
implements ICommand {
    @Override
    public void onCommand(CommandSender sender, String[] args) {
        block27: {
            long id;
            if (args.length < 1) {
                sender.sendMessage(I18N.translate("&cBad Syntax! &f/spt setproduct <id> [material] [count]", new Object[0]));
                return;
            }
            try {
                id = Long.parseLong(args[0]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(I18N.translate("&cInvalid Number!", new Object[0]));
                return;
            }
            if (CommandUtil.isNotAuthorized(sender, id)) {
                sender.sendMessage(I18N.translate("&cWhoops! You are not authorized to edit others products!", new Object[0]));
                return;
            }
            boolean wasProductValid = false;
            boolean wasCostValid = false;
            OfflinePlayer owner = null;
            try (ResultSet set = SmileyPlayerTrader.getInstance().getStatementHandler().get(StatementHandler.StatementType.GET_PRODUCT_BY_ID, id);){
                if (set.next()) {
                    if (set.getInt("stored_product") > 0) {
                        sender.sendMessage(I18N.translate("&cYou must withdraw all stored product before changing the product.", new Object[0]));
                        return;
                    }
                    owner = Bukkit.getOfflinePlayer((UUID)UUID.fromString(set.getString("merchant")));
                    wasProductValid = set.getBytes("product") != null;
                    wasCostValid = set.getBytes("cost1") != null;
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            try {
                if (args.length == 1) {
                    if (!(sender instanceof Player)) {
                        sender.sendMessage(I18N.translate("&cYou must be running this command from a player.", new Object[0]));
                        return;
                    }
                    Player p = (Player)sender;
                    if (p.getInventory().getItemInMainHand().getType().isAir()) {
                        sender.sendMessage(I18N.translate("&cYou must be holding an item in your main hand!", new Object[0]));
                        return;
                    }
                    byte[] item = VersionSupport.itemStackToByteArray(p.getInventory().getItemInMainHand());
                    SmileyPlayerTrader.getInstance().getStatementHandler().run(StatementHandler.StatementType.SET_PRODUCT, item, id);
                    sender.sendMessage(I18N.translate("&aProduct set!", new Object[0]));
                    if (wasCostValid && !wasProductValid && item != null) {
                        TradeNotification.sendNewTradeNotification(owner, p.getInventory().getItemInMainHand());
                    }
                    break block27;
                }
                if (args.length < 2) break block27;
                Material material = Material.matchMaterial((String)args[1]);
                if (material == null || !material.isItem() || material.isAir()) {
                    sender.sendMessage(I18N.translate("&c%0% isn't a valid item.", args[1]));
                    return;
                }
                int count = 1;
                try {
                    count = args.length > 2 ? Integer.parseInt(args[2]) : 1;
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(I18N.translate("&cInvalid Number!", new Object[0]));
                    return;
                }
                if (count < 1 || count > material.getMaxStackSize()) {
                    sender.sendMessage(I18N.translate("&cNumber is either too large or too small.", new Object[0]));
                    return;
                }
                ItemStack is = new ItemStack(material);
                is.setAmount(count);
                byte[] item = VersionSupport.itemStackToByteArray(is);
                SmileyPlayerTrader.getInstance().getStatementHandler().run(StatementHandler.StatementType.SET_PRODUCT, item, id);
                sender.sendMessage(I18N.translate("&aProduct set!", new Object[0]));
                if (wasCostValid && !wasProductValid && item != null) {
                    TradeNotification.sendNewTradeNotification(owner, is);
                }
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean isVisibleInTabComplete(CommandSender sender) {
        return true;
    }
}

