/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrcomputer1.smileyplayertrader.gui.framework.bedrock;

import io.github.mrcomputer1.smileyplayertrader.gui.framework.bedrock.BedrockGUI;
import java.util.ArrayList;
import java.util.List;
import org.geysermc.cumulus.form.SimpleForm;

public abstract class BedrockSimpleGUI
implements BedrockGUI {
    private final String name;
    private final List<SimpleButton> buttons = new ArrayList<SimpleButton>();
    private String content;

    public BedrockSimpleGUI(String name) {
        this.name = name;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void addButton(String button) {
        this.buttons.add(new SimpleButton(button, false));
    }

    public void addOptionalButton() {
        this.buttons.add(new SimpleButton(null, true));
    }

    public void removeButton(String button) {
        this.buttons.removeIf(b -> ((SimpleButton)b).text.equals(button));
    }

    @Override
    public final Object buildForm() {
        SimpleForm.Builder builder = SimpleForm.builder();
        builder.title(this.name);
        for (SimpleButton button : this.buttons) {
            if (button.optional) {
                builder.optionalButton(button.text, false);
                continue;
            }
            builder.button(button.text);
        }
        builder.closedResultHandler(this::onClose);
        builder.validResultHandler(response -> this.onSubmit(response.clickedButtonId()));
        return builder.build();
    }

    protected abstract void onClose();

    protected abstract void onSubmit(int var1);

    private static class SimpleButton {
        private final String text;
        private final boolean optional;

        public SimpleButton(String text, boolean optional) {
            this.text = text;
            this.optional = optional;
        }
    }
}

