/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrcomputer1.smileyplayertrader.gui.productmanage;

import io.github.mrcomputer1.smileyplayertrader.SmileyPlayerTrader;
import io.github.mrcomputer1.smileyplayertrader.gui.bedrock.BedrockGUIDiscount;
import io.github.mrcomputer1.smileyplayertrader.gui.bedrock.BedrockGUIPriority;
import io.github.mrcomputer1.smileyplayertrader.gui.bedrock.BedrockGUIPurchaseLimit;
import io.github.mrcomputer1.smileyplayertrader.gui.framework.GUI;
import io.github.mrcomputer1.smileyplayertrader.gui.framework.GUIComponent;
import io.github.mrcomputer1.smileyplayertrader.gui.framework.GUIManager;
import io.github.mrcomputer1.smileyplayertrader.gui.productmanage.GUIDiscount;
import io.github.mrcomputer1.smileyplayertrader.gui.productmanage.GUIPriority;
import io.github.mrcomputer1.smileyplayertrader.gui.productmanage.GUIProduct;
import io.github.mrcomputer1.smileyplayertrader.gui.productmanage.GUIPurchaseLimit;
import io.github.mrcomputer1.smileyplayertrader.gui.productmanage.ProductState;
import io.github.mrcomputer1.smileyplayertrader.util.GeyserUtil;
import io.github.mrcomputer1.smileyplayertrader.util.I18N;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ProductMenuBarComponent
extends GUIComponent {
    private static final ItemStack BACKGROUND = GUI.createItem(Material.IRON_BARS, 1, ChatColor.RESET.toString());
    private static final ItemStack PRODUCT_SETTING = GUI.createItem(Material.EMERALD, 1, I18N.translate("&eProduct Settings", new Object[0]));
    private static final ItemStack PRIORITY_SETTING = GUI.createItemWithLore(Material.NETHER_STAR, 1, I18N.translate("&eSet Priority", new Object[0]), I18N.translate("&eHigher priorities appear higher in the trade list.", new Object[0]));
    private static final ItemStack DISCOUNT_SETTING = GUI.createItem(Material.IRON_INGOT, 1, I18N.translate("&eSet Optional Discount", new Object[0]));
    private static final ItemStack PURCHASE_LIMIT = GUI.createItem(Material.LIGHT_BLUE_WOOL, 1, I18N.translate("&ePurchase Limit", new Object[0]));
    private static final ItemStack HIDE_ON_OUT_OF_STOCK = GUI.createItemWithLore(Material.YELLOW_WOOL, 1, I18N.translate("&eToggle hide on out of stock", new Object[0]), I18N.translate("&eWhen enabled, this trade will be hidden when out of stock.", new Object[0]));
    private final ProductState state;
    private final EnumProductEditPage editPage;
    private Inventory inventory;
    private ItemStack hideOnOutOfStock;

    public ProductMenuBarComponent(int row, ProductState state, EnumProductEditPage editPage) {
        super(0, row, 9, 1);
        this.state = state;
        this.editPage = editPage;
    }

    private void renderSelected(ItemStack stack) {
        ItemMeta im = stack.getItemMeta();
        assert (im != null);
        ArrayList<String> lore = im.hasLore() ? new ArrayList(im.getLore()) : new ArrayList<String>();
        lore.add(0, I18N.translate("&aSelected", new Object[0]));
        im.setLore(lore);
        stack.setItemMeta(im);
    }

    private void updateHideOnOutOfStock() {
        ItemMeta im = this.hideOnOutOfStock.getItemMeta();
        assert (im != null);
        if (this.state.hideOnOutOfStock) {
            im.addEnchant(Enchantment.DURABILITY, 1, true);
            im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        } else {
            im.removeEnchant(Enchantment.DURABILITY);
            im.removeItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        this.hideOnOutOfStock.setItemMeta(im);
    }

    @Override
    public void render(Inventory inventory) {
        this.inventory = inventory;
        for (int i = 0; i < this.width; ++i) {
            inventory.setItem(GUI.toSlot(i, this.y), BACKGROUND.clone());
        }
        ItemStack productSetting = PRODUCT_SETTING.clone();
        if (this.editPage == EnumProductEditPage.PRODUCT_SETTINGS) {
            this.renderSelected(productSetting);
        }
        inventory.setItem(GUI.toSlot(0, this.y), productSetting);
        ItemStack prioritySetting = PRIORITY_SETTING.clone();
        if (this.editPage == EnumProductEditPage.PRIORITY) {
            this.renderSelected(prioritySetting);
        }
        inventory.setItem(GUI.toSlot(1, this.y), prioritySetting);
        ItemStack discountSetting = DISCOUNT_SETTING.clone();
        if (this.editPage == EnumProductEditPage.DISCOUNT) {
            this.renderSelected(discountSetting);
        }
        inventory.setItem(GUI.toSlot(2, this.y), discountSetting);
        ItemStack purchaseLimit = PURCHASE_LIMIT.clone();
        if (this.editPage == EnumProductEditPage.PURCHASE_LIMIT) {
            this.renderSelected(purchaseLimit);
        }
        inventory.setItem(GUI.toSlot(3, this.y), purchaseLimit);
        switch (SmileyPlayerTrader.getInstance().getConfiguration().getOutOfStockBehaviour()) {
            case HIDE_BY_DEFAULT: 
            case SHOW_BY_DEFAULT: {
                this.hideOnOutOfStock = HIDE_ON_OUT_OF_STOCK.clone();
                this.updateHideOnOutOfStock();
                inventory.setItem(GUI.toSlot(4, this.y), this.hideOnOutOfStock);
            }
        }
    }

    @Override
    public boolean onClick(ClickType type, int x, int y, Player player, ItemStack clickedStack) {
        if (x == 0) {
            GUIManager.getInstance().openGui(player, new GUIProduct(player, this.state));
        } else if (x == 1) {
            if (GeyserUtil.isBedrockPlayer(player)) {
                player.closeInventory();
                GeyserUtil.showFormDelayed(player, new BedrockGUIPriority(player, this.state));
            } else {
                GUIManager.getInstance().openGui(player, new GUIPriority(this.state));
            }
        } else if (x == 2) {
            if (GeyserUtil.isBedrockPlayer(player)) {
                player.closeInventory();
                GeyserUtil.showFormDelayed(player, new BedrockGUIDiscount(player, this.state));
            } else {
                GUIManager.getInstance().openGui(player, new GUIDiscount(this.state));
            }
        } else if (x == 3) {
            if (GeyserUtil.isBedrockPlayer(player)) {
                player.closeInventory();
                GeyserUtil.showFormDelayed(player, new BedrockGUIPurchaseLimit(player, this.state));
            } else {
                GUIManager.getInstance().openGui(player, new GUIPurchaseLimit(this.state));
            }
        } else if (x == 4 && this.hideOnOutOfStock != null) {
            this.state.hideOnOutOfStock = !this.state.hideOnOutOfStock;
            this.updateHideOnOutOfStock();
            this.inventory.setItem(GUI.toSlot(4, this.y), this.hideOnOutOfStock);
        }
        return false;
    }

    public static enum EnumProductEditPage {
        PRODUCT_SETTINGS,
        PRIORITY,
        DISCOUNT,
        PURCHASE_LIMIT;

    }
}

