/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrcomputer1.smileyplayertrader.util;

import io.github.mrcomputer1.smileyplayertrader.gui.framework.bedrock.BedrockGUI;
import io.github.mrcomputer1.smileyplayertrader.util.impl.bedrock.IBedrockImpl;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class GeyserUtil {
    private static final String GEYSER_PLUGIN = "Geyser-Spigot";
    private static final String FLOODGATE_PLUGIN = "floodgate";
    private static IBedrockImpl bedrockImpl;

    private static boolean isFloodgate() {
        return Bukkit.getPluginManager().getPlugin(FLOODGATE_PLUGIN) != null;
    }

    private static boolean isGeyser() {
        return Bukkit.getPluginManager().getPlugin(GEYSER_PLUGIN) != null;
    }

    private static boolean isCumulusAvailable() {
        return GeyserUtil.isFloodgate() || GeyserUtil.isGeyser();
    }

    private static boolean bindBedrockImplIfPossible() {
        if (!GeyserUtil.isCumulusAvailable()) {
            return false;
        }
        if (bedrockImpl != null) {
            return true;
        }
        try {
            Class<?> clazz;
            if (GeyserUtil.isFloodgate()) {
                clazz = Class.forName("io.github.mrcomputer1.smileyplayertrader.util.impl.bedrock.FloodgateImpl");
            } else if (GeyserUtil.isGeyser()) {
                clazz = Class.forName("io.github.mrcomputer1.smileyplayertrader.util.impl.bedrock.GeyserImpl");
            } else {
                return false;
            }
            bedrockImpl = (IBedrockImpl)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            return true;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            return false;
        }
    }

    public static boolean isBedrockPlayer(Player player) {
        if (!GeyserUtil.bindBedrockImplIfPossible()) {
            return false;
        }
        return bedrockImpl.isBedrockPlayer(player);
    }

    public static void showSimpleForm(Player player, String title, String content) {
        if (!GeyserUtil.bindBedrockImplIfPossible()) {
            return;
        }
        bedrockImpl.showSimpleForm(player, title, content);
    }

    public static void showConfirmationForm(Player player, String title, String content, Consumer<Boolean> callback) {
        if (!GeyserUtil.bindBedrockImplIfPossible()) {
            return;
        }
        bedrockImpl.showConfirmationForm(player, title, content, callback);
    }

    public static void showFormDelayed(Player player, BedrockGUI gui) {
        if (!GeyserUtil.bindBedrockImplIfPossible()) {
            return;
        }
        bedrockImpl.showFormDelayed(player, gui);
    }

    public static void showForm(Player player, BedrockGUI gui) {
        if (!GeyserUtil.bindBedrockImplIfPossible()) {
            return;
        }
        bedrockImpl.showForm(player, gui);
    }
}

