/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrcomputer1.smileyplayertrader.util.database;

import io.github.mrcomputer1.smileyplayertrader.SmileyPlayerTrader;
import io.github.mrcomputer1.smileyplayertrader.util.database.AbstractDatabase;
import io.github.mrcomputer1.smileyplayertrader.util.database.MySQLDatabase;
import io.github.mrcomputer1.smileyplayertrader.util.database.SQLiteDatabase;
import java.io.File;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class DatabaseUtil {
    public static AbstractDatabase loadDatabase() {
        AbstractDatabase db;
        switch (SmileyPlayerTrader.getInstance().getConfiguration().getDatabaseType()) {
            case "sqlite": {
                db = new SQLiteDatabase(new File(SmileyPlayerTrader.getInstance().getDataFolder(), SmileyPlayerTrader.getInstance().getConfiguration().getDatabaseFile()));
                break;
            }
            case "mysql": {
                if (!(SmileyPlayerTrader.getInstance().getConfig().contains("database.host") && SmileyPlayerTrader.getInstance().getConfig().contains("database.name") && SmileyPlayerTrader.getInstance().getConfig().contains("database.username") && SmileyPlayerTrader.getInstance().getConfig().contains("database.password"))) {
                    SmileyPlayerTrader.getInstance().getLogger().severe("Failed to connect to database, a required property is missing from config (host, name, username or password)");
                    Bukkit.getPluginManager().disablePlugin((Plugin)SmileyPlayerTrader.getInstance());
                    return null;
                }
                db = new MySQLDatabase(SmileyPlayerTrader.getInstance().getConfiguration().getDatabaseHost(), SmileyPlayerTrader.getInstance().getConfiguration().getDatabasePort(), SmileyPlayerTrader.getInstance().getConfiguration().getDatabaseName(), SmileyPlayerTrader.getInstance().getConfiguration().getDatabaseUsername(), SmileyPlayerTrader.getInstance().getConfiguration().getDatabasePassword());
                break;
            }
            default: {
                SmileyPlayerTrader.getInstance().getLogger().severe("Invalid database type! Supported types are sqlite and mysql!");
                Bukkit.getPluginManager().disablePlugin((Plugin)SmileyPlayerTrader.getInstance());
                return null;
            }
        }
        return db;
    }
}

